/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main;

import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.buttons.Checkbox;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;

public class SettingsResetPanel
extends SimplePanel {
    private Checkbox[] checkboxes = new Checkbox[0];
    private Checkbox resetGameSettings;
    private Checkbox resetInputSettings;
    private Checkbox resetVideoSettings;
    private Checkbox resetSkinSettings;
    private AstraXTextButton backButton;
    private AstraXTextButton applyButton;
    private ResetPanelListener listener;

    public SettingsResetPanel(ComponentFactory componentFactory) {
        super(componentFactory, "default", "window-body");
        this.resetGameSettings = new Checkbox(componentFactory, "checkbox");
        this.resetInputSettings = new Checkbox(componentFactory, "checkbox");
        this.resetVideoSettings = new Checkbox(componentFactory, "checkbox");
        this.resetSkinSettings = new Checkbox(componentFactory, "checkbox");
        this.checkboxes = new Checkbox[]{this.resetGameSettings, this.resetInputSettings, this.resetVideoSettings, this.resetSkinSettings};
        this.backButton = new AstraXTextButton(componentFactory, "secondary-compact");
        this.backButton.setText(this.componentFactory.translate("form_back"));
        this.backButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (SettingsResetPanel.this.getListener() != null) {
                    SettingsResetPanel.this.getListener().onBack();
                }
            }
        }));
        this.applyButton = new AstraXTextButton(componentFactory, "primary-compact");
        this.applyButton.setText(this.componentFactory.translate("form_apply"));
        this.applyButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (SettingsResetPanel.this.getListener() != null) {
                    SettingsResetPanel.this.getListener().onReset(SettingsResetPanel.this.resetGameSettings.isChecked(), SettingsResetPanel.this.resetInputSettings.isChecked(), SettingsResetPanel.this.resetVideoSettings.isChecked(), SettingsResetPanel.this.resetSkinSettings.isChecked());
                }
            }
        }));
        this.addLabel(this.componentFactory.translate("settings_hint_reset"), 2);
        this.row();
        this.addRow(this.componentFactory.translate("settings_general"), this.resetGameSettings);
        this.row();
        this.addRow(this.componentFactory.translate("settings_gui"), this.resetSkinSettings);
        this.row();
        this.addRow(this.componentFactory.translate("settings_controls"), this.resetInputSettings);
        this.row();
        this.addRow(this.componentFactory.translate("settings_video"), this.resetVideoSettings);
        this.row();
        this.addValue(this.backButton);
        this.addValue(this.applyButton);
        this.pack();
    }

    public ResetPanelListener getListener() {
        return this.listener;
    }

    public void setListener(ResetPanelListener listener) {
        this.listener = listener;
    }

    static interface ResetPanelListener {
        public void onReset(Boolean var1, Boolean var2, Boolean var3, Boolean var4);

        public void onBack();
    }
}

