/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.gfx.factories.AvatarFactory;
import com.neutronio.astrax.ui.AstraXSkin;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.CompositeButton;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.main.CharacterInfo;
import java.util.List;

public class UserProfilePanel
extends CompositeButton {
    private AvatarFactory avatarFactory;
    private CharacterInfo playerInfo;
    private Image symbol;
    private Group avatarGroup;

    public UserProfilePanel(ComponentFactory componentFactory) {
        super(componentFactory);
        this.setSquishable(false);
        this.avatarFactory = new AvatarFactory();
        this.avatarFactory.setSkin((AstraXSkin)this.componentFactory.getSkin());
        this.avatarGroup = new Group();
        this.avatarGroup.setScale(3.67f);
        this.symbol = new Image(componentFactory.getSkin().getDrawable("symbol_1"));
        this.playerInfo = new CharacterInfo(componentFactory);
        AstraXLabel unitedPlanetsLabel = new AstraXLabel(componentFactory, "United Planets", "default", null);
        AstraXLabel licenseLabel = new AstraXLabel(componentFactory, "Spaceflight License", "small", null);
        licenseLabel.setAlignment(1, 1);
        Table headerText = new Table();
        headerText.left();
        headerText.add(unitedPlanetsLabel);
        headerText.row().padBottom(this.panelStyle.rowPadding);
        headerText.add(licenseLabel);
        headerText.pack();
        Table headerGroup = new Table();
        headerGroup.left();
        headerGroup.add(this.symbol).size(32.0f, 32.0f).left();
        headerGroup.add(headerText).padLeft(10.0f).fill();
        headerGroup.pack();
        this.padLeft(15.0f).padTop(7.0f).padBottom(10.0f);
        this.addValue(headerGroup, 2).left();
        this.row().padBottom(this.panelStyle.rowPadding);
        this.addValue(this.playerInfo);
        this.pack();
    }

    public void update(UserProfile userProfile) {
        if (userProfile == null) {
            Image placeholder = new Image(this.componentFactory.getSkin().getDrawable("avatar_placeholder"));
            this.playerInfo.updateAvatar(placeholder);
            this.playerInfo.update("Please click to pick", "a user!", "None selected!");
        } else {
            List<Image> images = this.avatarFactory.create(userProfile.avatarTextureIndices, userProfile.avatarColorIndices, "avatar_human");
            this.avatarGroup.clear();
            for (Image image : images) {
                this.avatarGroup.addActor(image);
            }
            if (!this.avatarGroup.hasParent()) {
                this.playerInfo.updateAvatar(this.avatarGroup);
            }
            this.playerInfo.update(userProfile.playerName, "First Officer", userProfile.id);
        }
        this.centerBackground();
    }
}

