/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.loadgame;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.CompositeButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.util.DateFormats;
import com.neutronio.astrax.util.StandardFormats;

public class SavedGameEntry
extends CompositeButton {
    private AstraXLabel gameNameValue;
    private AstraXLabel galaxyValue;
    private AstraXLabel lastPlayedValue;
    private AstraXLabel playTimeValue;
    private AstraXButton deleteButton;
    private IconLabel chipcoin;
    private IconLabel discoveryPoints;
    private SavedGameEntryListener listener;

    public SavedGameEntry(ComponentFactory componentFactory) {
        super(componentFactory);
        this.gameNameValue = new AstraXLabel(componentFactory, "", "header-no-bg", null);
        this.gameNameValue.setTouchable(Touchable.disabled);
        this.gameNameValue.setEllipsis(true);
        this.galaxyValue = new AstraXLabel(componentFactory, "", "default", null);
        this.galaxyValue.setTouchable(Touchable.disabled);
        this.lastPlayedValue = new AstraXLabel(componentFactory, "", "default", null);
        this.lastPlayedValue.setAlignment(16, 1);
        this.lastPlayedValue.setTouchable(Touchable.disabled);
        this.playTimeValue = new AstraXLabel(componentFactory, "", "default", null);
        this.playTimeValue.setAlignment(8, 1);
        this.playTimeValue.setTouchable(Touchable.disabled);
        this.chipcoin = new IconLabel(componentFactory, "inline-saved-game");
        this.chipcoin.set("icon_inline_coins", "0");
        this.chipcoin.setLabelAlign(16);
        this.chipcoin.setTouchable(Touchable.disabled);
        this.discoveryPoints = new IconLabel(componentFactory, "inline-saved-game");
        this.discoveryPoints.set("icon_inline_research", "0");
        this.discoveryPoints.setLabelAlign(16);
        this.discoveryPoints.setTouchable(Touchable.disabled);
        this.deleteButton = new AstraXButton(componentFactory, "icon_inline_trash", "control-red-large");
        this.deleteButton.setCanCheck(false);
        this.deleteButton.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                event.setBubbles(false);
                event.stop();
                if (SavedGameEntry.this.getListener() != null) {
                    SavedGameEntry.this.getListener().onDeleteButtonClicked((SavedGame)SavedGameEntry.this.getUserObject());
                }
            }
        });
        Table gameProperties = new Table();
        gameProperties.add(this.chipcoin).padRight(10.0f);
        gameProperties.add(this.discoveryPoints);
        gameProperties.pack();
        Table gameTimes = new Table();
        gameTimes.add(this.lastPlayedValue).padRight(10.0f);
        gameTimes.add(this.playTimeValue);
        gameTimes.pack();
        this.left();
        SimplePanel entryWrapper = new SimplePanel(componentFactory);
        entryWrapper.left();
        entryWrapper.addValue(this.gameNameValue).minWidth((float)ComponentFactory.SECONDARY_TAB_WIDTH * 0.45f).left();
        entryWrapper.addValue(gameTimes).right().padBottom(20.0f);
        entryWrapper.row();
        entryWrapper.addValue(this.galaxyValue).left();
        entryWrapper.addValue(gameProperties).left();
        this.addValue(this.deleteButton).size(64.0f, 64.0f).padRight(50.0f).center();
        this.addValue(entryWrapper);
        this.pack();
        this.centerBackground();
    }

    private SavedGameEntryListener getListener() {
        return this.listener;
    }

    public void setListener(SavedGameEntryListener listener) {
        this.listener = listener;
    }

    public void setSavedGame(SavedGame savedGame) {
        if (savedGame != null) {
            this.deleteButton.setVisible(true);
            this.gameNameValue.setText(savedGame.gameName);
            this.galaxyValue.setText(savedGame.currentGalaxyName);
            this.playTimeValue.setText(savedGame.playTime.toString());
            this.lastPlayedValue.setText(DateFormats.FULL.format(savedGame.lastPlayed));
            this.chipcoin.setIconVisible(true);
            this.discoveryPoints.setIconVisible(true);
            this.chipcoin.setText(StandardFormats.INTEGER.format(savedGame.chipcoin));
            this.discoveryPoints.setText(StandardFormats.INTEGER.format(savedGame.discoveryPoints));
        } else {
            this.deleteButton.setVisible(false);
            this.gameNameValue.setText("");
            this.galaxyValue.setText("");
            this.playTimeValue.setText("");
            this.lastPlayedValue.setText("");
            this.chipcoin.setText("");
            this.chipcoin.setIconVisible(false);
            this.discoveryPoints.setIconVisible(false);
            this.discoveryPoints.setText("");
        }
        this.pack();
        this.centerBackground();
    }

    public static interface SavedGameEntryListener {
        public void onDeleteButtonClicked(SavedGame var1);
    }
}

