/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.loadgame;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.UserProfileFactory;
import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;
import com.neutronio.astrax.ui.commons.widgets.dialog.DialogBox;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.main.loadgame.SavedGameEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SavedGamePicker
extends SimplePanel
implements SavedGameEntry.SavedGameEntryListener {
    private AstraXTextButton backButton;
    private Palette<SavedGameEntry, SavedGame> gamePalette;
    private PaginatorComponent paginatorComponent;
    private SavedGameComparator comparator = new SavedGameComparator();

    public SavedGamePicker(ComponentFactory componentFactory) {
        super(componentFactory);
        this.backButton = new AstraXTextButton(componentFactory, "secondary");
        this.backButton.setText(componentFactory.translate("form_back"));
        this.backButton.setCanCheck(false);
        this.gamePalette = new Palette(componentFactory);
        this.gamePalette.setIconCount(5);
        this.gamePalette.setColumns(1);
        this.gamePalette.setButtonProducer(new Palette.ButtonUpdater<SavedGameEntry, SavedGame>(){

            @Override
            public SavedGameEntry createButton(ComponentFactory componentFactory, String style) {
                SavedGameEntry entry = new SavedGameEntry(componentFactory);
                entry.setCanCheck(false);
                entry.setSquishable(false);
                return entry;
            }

            @Override
            public void updateButton(SavedGameEntry button, SavedGame savedGame) {
                button.setDisabled(false);
                button.setUserObject(savedGame);
                button.setSavedGame(savedGame);
            }

            @Override
            public void resetButton(SavedGameEntry button) {
                button.setUserObject(null);
                button.setSavedGame(null);
                button.setDisabled(true);
            }
        });
        this.gamePalette.getButtonGroup().setMaxCheckCount(1);
        this.gamePalette.getButtonGroup().setMinCheckCount(0);
        this.gamePalette.fillWithButtons(null);
        for (SavedGameEntry savedGameEntry : this.gamePalette.getButtons()) {
            savedGameEntry.setListener(this);
        }
        this.paginatorComponent = new PaginatorComponent(componentFactory);
        this.paginatorComponent.setPaginator(this.gamePalette);
        this.addValue(this.gamePalette, 2);
        this.row();
        this.addValue(this.backButton);
        this.addValue(this.paginatorComponent);
        this.pack();
    }

    public void setSavedGames(List<SavedGame> savedGames) {
        Collections.sort(savedGames, this.comparator);
        this.gamePalette.clearItems();
        this.gamePalette.addItems(savedGames);
        this.gamePalette.updateToContent();
        this.paginatorComponent.update();
    }

    public Palette<SavedGameEntry, SavedGame> getGamePalette() {
        return this.gamePalette;
    }

    public AstraXTextButton getBackButton() {
        return this.backButton;
    }

    @Override
    public void onDeleteButtonClicked(final SavedGame savedGame) {
        String deleteMessage = this.componentFactory.translate("dialog_question_delete", savedGame.gameName) + "\n\n" + this.componentFactory.translate("dialog_question_delete_data");
        AstraXApp.astraX.showDialogBox(deleteMessage, new DialogBox.DialogBoxListener(){

            @Override
            public void onProceed() {
                UserProfileFactory userProfileFactory = AstraXApp.astraX.getAppFactoryByClass(UserProfileFactory.class);
                boolean success = userProfileFactory.deleteSavedGame(AstraXApp.astraX.getActiveUserProfile(), savedGame);
                SavedGamePicker.this.setSavedGames(AstraXApp.astraX.getActiveUserProfile().savedGames);
                if (success) {
                    AstraXApp.astraX.showSuccessAlert(SavedGamePicker.this.componentFactory.translate("menu_savegame_message_removed_success"));
                } else {
                    AstraXApp.astraX.showErrorAlert(SavedGamePicker.this.componentFactory.translate("menu_savegame_message_removed_error"));
                }
            }

            @Override
            public void onCancel() {
            }
        });
    }

    private class SavedGameComparator
    implements Comparator<SavedGame> {
        private SavedGameComparator() {
        }

        @Override
        public int compare(SavedGame o1, SavedGame o2) {
            if (o1.lastPlayed != null && o2.lastPlayed == null) {
                return -1;
            }
            if (o1.lastPlayed == null && o2.lastPlayed != null) {
                return 1;
            }
            if (o1.lastPlayed.getTime() == o2.lastPlayed.getTime()) {
                return 0;
            }
            if (o1.lastPlayed.getTime() > o2.lastPlayed.getTime()) {
                return -1;
            }
            return 1;
        }
    }
}

