/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.newgame;

import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.app.datapack.NameFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxySettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyTypeRepository;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyTypeSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.util.MathUtil;
import java.util.List;
import java.util.Random;

public class GalaxyPanel
extends AbstractForm {
    private SimplePanel galaxyValues;
    private SelectBox<SelectBoxWrapper<GalaxyTypeSettings>> galaxyTypeSelectBox;
    private Image galaxyTexture;
    private TextureRegion galaxyTextureRegion;
    private TextField galaxyNameTextArea;
    private TextArea galaxyDescriptionTextArea;
    private AstraXButton galaxyNameRandomizerIcon;
    private SelectBox<SelectBoxWrapper<String>> starterSystemSelectBox;
    private AstraXButton coordsRandomizerIcon;
    private TextField xCoordsTextArea;
    private TextField yCoordsTextArea;
    private HorizontalGroup coordsTable = null;
    private GalaxyFactory galaxyFactory;
    private int sectorMax = 259;

    public GalaxyPanel(ComponentFactory componentFactory) {
        super(componentFactory, "newgame", "outset");
        this.pad(15.0f);
        long seed = new Random().nextLong();
        AstraXApp.astraX.getFactoryByClass(NameFactory.class).setSeed(seed);
        this.galaxyFactory = AstraXApp.astraX.getFactoryByClass(GalaxyFactory.class);
        this.galaxyFactory.setSeed(seed);
        this.galaxyValues = new SimplePanel(componentFactory);
        this.galaxyNameTextArea = new TextField(this.galaxyFactory.generateName(), componentFactory.getSkin());
        this.galaxyDescriptionTextArea = new TextArea("", componentFactory.getSkin());
        this.galaxyDescriptionTextArea.setPrefRows(3.0f);
        this.galaxyDescriptionTextArea.setDisabled(true);
        this.coordsRandomizerIcon = new AstraXButton(componentFactory, "icon_inline_dice", "primary");
        this.coordsRandomizerIcon.setCanCheck(false);
        this.coordsRandomizerIcon.addListener(componentFactory.getButtonSoundListener("dice"));
        this.coordsRandomizerIcon.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                GalaxyPanel.this.xCoordsTextArea.setText(MathUtil.getRandomInteger(GalaxyPanel.this.sectorMax) - GalaxyPanel.this.sectorMax / 2 + "");
                GalaxyPanel.this.yCoordsTextArea.setText(MathUtil.getRandomInteger(GalaxyPanel.this.sectorMax) - GalaxyPanel.this.sectorMax / 2 + "");
                super.clicked(event, x, y);
            }
        });
        this.galaxyNameRandomizerIcon = new AstraXButton(componentFactory, "icon_inline_dice", "primary");
        this.galaxyNameRandomizerIcon.setCanCheck(false);
        this.galaxyNameRandomizerIcon.addListener(componentFactory.getButtonSoundListener("dice"));
        this.galaxyNameRandomizerIcon.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                GalaxyPanel.this.galaxyNameTextArea.setText(GalaxyPanel.this.galaxyFactory.generateName());
            }
        });
        this.galaxyTexture = new Image();
        this.galaxyTypeSelectBox = new SelectBox(componentFactory.getSkin());
        this.galaxyTypeSelectBox.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                GalaxyPanel.this.onGalaxyTypeChanged();
            }
        });
        Array<SelectBoxWrapper<GalaxyTypeSettings>> galaxyTypeList = new Array<SelectBoxWrapper<GalaxyTypeSettings>>();
        GalaxyTypeRepository repository = AstraXApp.astraX.getRepository(GalaxyTypeRepository.class);
        List allGalaxyTypes = repository.all();
        for (GalaxyTypeSettings typeSettings : allGalaxyTypes) {
            galaxyTypeList.add(new SelectBoxWrapper<GalaxyTypeSettings>(typeSettings.galaxyClass.getDisplayName(), typeSettings));
        }
        this.galaxyTypeSelectBox.setItems(galaxyTypeList);
        this.starterSystemSelectBox = new SelectBox(componentFactory.getSkin());
        this.starterSystemSelectBox.setItems(new SelectBoxWrapper<String>("Solar System", "solarsystem_sol"), new SelectBoxWrapper<String>("Toxic System", "solarsystem_toxic"), new SelectBoxWrapper<String>("Dwarf System", "solarsystem_dwarf"), new SelectBoxWrapper<String>("Alien System", "solarsystem_ancientCiv"));
        this.coordsTable = new HorizontalGroup();
        this.coordsTable.space(this.panelStyle.columnPadding);
        this.coordsTable.right();
        this.xCoordsTextArea = new TextField("0", componentFactory.getSkin());
        this.xCoordsTextArea.setWidth(50.0f);
        this.yCoordsTextArea = new TextField("0", componentFactory.getSkin());
    }

    @Override
    public void resetValues() {
    }

    public void setAvailableStarterSystems(SelectBoxWrapper[] starterSystems) {
        this.starterSystemSelectBox.setItems(starterSystems);
    }

    public GalaxySettings getGalaxySettings() {
        GalaxySettings galaxySettings = new GalaxySettings(this.galaxyTypeSelectBox.getSelected().getPayload());
        galaxySettings.galaxyName = this.galaxyNameTextArea.getText();
        galaxySettings.starterSystem = this.starterSystemSelectBox.getSelected().getPayload();
        try {
            Integer xCoords = Integer.parseInt(this.xCoordsTextArea.getText().trim());
            Integer yCoords = Integer.parseInt(this.yCoordsTextArea.getText().trim());
            galaxySettings.xSectorStartPos = MathUtils.clamp(xCoords, -this.sectorMax / 2, this.sectorMax / 2);
            galaxySettings.ySectorStartPos = MathUtils.clamp(yCoords, -this.sectorMax / 2, this.sectorMax / 2);
        }
        catch (NumberFormatException e) {
            throw new AstraXException(AstraXException.ErrorCode.E0003, "Coords must be integers. Was the form validated prior calling this method?");
        }
        return galaxySettings;
    }

    private void onGalaxyTypeChanged() {
        GalaxyTypeSettings type = this.galaxyTypeSelectBox.getSelected().getPayload();
        this.galaxyDescriptionTextArea.setText(type.galaxyClass.getDescription());
        this.setGalaxyImage(type.galaxyTexture);
    }

    private void setGalaxyImage(String drawableName) {
        TextureRegion region;
        this.galaxyTextureRegion = region = this.componentFactory.getSkin().getRegion(drawableName);
        this.sectorMax = region.getRegionWidth();
        this.galaxyTexture.setDrawable(new TextureRegionDrawable(region));
    }

    @Override
    public void construct() {
        this.clear();
        this.coordsTable.clear();
        super.construct();
        this.addHeader("Galaxy Settings", 400.0f, 3);
        this.row();
        Table galaxyName = new Table();
        galaxyName.right();
        galaxyName.add(this.galaxyNameTextArea).expand().fill().padRight(this.panelStyle.columnPadding);
        galaxyName.add(this.galaxyNameRandomizerIcon);
        galaxyName.pack();
        this.galaxyValues.addLabel("Name", 1);
        this.galaxyValues.add(galaxyName).padBottom(this.panelStyle.rowPadding).colspan(2).fill();
        this.galaxyValues.row();
        this.galaxyValues.addRow("Type", this.galaxyTypeSelectBox, 1);
        this.galaxyValues.row();
        this.galaxyValues.addValue(this.galaxyDescriptionTextArea, 2);
        this.galaxyValues.row();
        this.galaxyValues.addHeader("Starter System", 2);
        this.galaxyValues.row();
        this.galaxyValues.addRow("Type", this.starterSystemSelectBox, 1);
        this.galaxyValues.row();
        this.coordsTable.addActor(this.xCoordsTextArea);
        this.coordsTable.addActor(this.yCoordsTextArea);
        this.coordsTable.addActor(this.coordsRandomizerIcon);
        this.coordsTable.pack();
        this.galaxyValues.addRow("Coordinates", this.coordsTable, 1);
        this.galaxyValues.getCell(this.coordsTable).fill();
        this.add(this.galaxyValues).padRight(10.0f);
        this.add(this.galaxyTexture).minSize(256.0f, 256.0f).center();
        this.row();
        this.pack();
    }

    @Override
    public ValidationResult validateForm(ValidationResult validationResult) {
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        try {
            Integer xCoords = Integer.parseInt(this.xCoordsTextArea.getText().trim());
            Integer n = Integer.parseInt(this.yCoordsTextArea.getText().trim());
        }
        catch (NumberFormatException e) {
            validationResult.addMessage("Coords must be an integer!", this.coordsTable);
        }
        this.markLabels(validationResult);
        return validationResult;
    }

    @Override
    public void resetForm() {
        this.xCoordsTextArea.setText("0");
        this.yCoordsTextArea.setText("0");
        this.galaxyNameTextArea.setText(this.galaxyFactory.generateName());
        this.galaxyTypeSelectBox.setSelectedIndex(0);
        this.onGalaxyTypeChanged();
    }
}

