/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.newgame;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.NameFactory;
import com.neutronio.astrax.app.datapack.game.GameDifficulty;
import com.neutronio.astrax.app.datapack.game.GameSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.ButtonClickListener;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.text.TextSelector;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.util.NameRandomizer;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import java.util.Date;
import java.util.regex.Pattern;

public class GamePanel
extends AbstractForm {
    private IconLabel infoLabel;
    private TextArea nameTextArea;
    private TextArea seedTextArea;
    private AstraXButton seedRandomizerIcon;
    private AstraXButton gameNameRandomizerIcon;
    private NameRandomizer nameRandomizer;
    private NumberGenerator numberGenerator;
    private NameFactory nameFactory;
    private String[] gameNamePatterns = new String[]{"adventure-prefix mystery-places", "size-large mystery-places", "size-large mystery-prefix mystery-places", "mystery-prefix mystery-places", "wreck-prefix mystery-places", "adventure-prefix mythical-names", "size-large mythical-names", "size-large mystery-prefix mythical-names", "mystery-prefix mythical-names", "wreck-prefix mythical-names", "adventure-prefix exploration-names", "size-large exploration-names", "size-large mystery-prefix exploration-names", "mystery-prefix exploration-names", "wreck-prefix exploration-names", "adventure-prefix nebula-names", "size-large nebula-names", "size-large mystery-prefix nebula-names", "mystery-prefix nebula-names", "wreck-prefix nebula-names", "adventure-prefix adventure-names", "size-large adventure-names", "size-large mystery-prefix adventure-names", "mystery-prefix adventure-names", "wreck-prefix adventure-names"};
    private TextSelector<GameDifficulty> difficultyTextSelector;

    public GamePanel(ComponentFactory componentFactory, Skin skin) {
        super(componentFactory, "newgame", "outset");
        this.nameFactory = AstraXApp.astraX.getFactoryByClass(NameFactory.class);
        this.numberGenerator = new NumberGenerator(new Date().getTime());
        this.infoLabel = new IconLabel(componentFactory, "warning");
        this.infoLabel.setText("Inactive. Coming soon!");
        this.nameRandomizer = new NameRandomizer();
        this.nameRandomizer.setNumberGenerator(this.numberGenerator);
        this.nameTextArea = new TextArea("", skin);
        this.nameTextArea.setPrefRows(1.0f);
        this.createAndSetRandomGameName();
        this.seedTextArea = new TextArea("", skin);
        this.seedTextArea.setPrefRows(1.0f);
        this.createAndSetRandomSeed();
        this.gameNameRandomizerIcon = new AstraXButton(componentFactory, "icon_inline_dice", "primary");
        this.gameNameRandomizerIcon.setCanCheck(false);
        this.gameNameRandomizerIcon.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                GamePanel.this.createAndSetRandomGameName();
            }
        });
        this.seedRandomizerIcon = new AstraXButton(componentFactory, "icon_inline_dice", "primary");
        this.seedRandomizerIcon.setCanCheck(false);
        this.seedRandomizerIcon.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                GamePanel.this.createAndSetRandomSeed();
            }
        });
        ButtonClickListener diceSound = componentFactory.getButtonSoundListener("dice");
        this.seedRandomizerIcon.addListener(diceSound);
        this.gameNameRandomizerIcon.addListener(diceSound);
        this.difficultyTextSelector = new TextSelector(componentFactory);
        this.difficultyTextSelector.addItem(new SelectBoxWrapper<GameDifficulty>("Easy", GameDifficulty.EASY));
        this.difficultyTextSelector.addItem(new SelectBoxWrapper<GameDifficulty>("Medium", GameDifficulty.MEDIUM));
        this.difficultyTextSelector.addItem(new SelectBoxWrapper<GameDifficulty>("Hard", GameDifficulty.HARD));
        this.difficultyTextSelector.setSelectedIndex(0, false);
        this.difficultyTextSelector.setTextSpace(20.0f);
        this.difficultyTextSelector.setTextMinWidth(70.0f);
    }

    private void createAndSetRandomSeed() {
        this.seedTextArea.setText("" + this.nameRandomizer.getNumberGenerator().getRandomInteger(Integer.MAX_VALUE, 0));
    }

    private void createAndSetRandomGameName() {
        String gameName = this.nameFactory.createName(this.numberGenerator, this.numberGenerator.getRandomEntry(this.gameNamePatterns));
        this.nameTextArea.setText(gameName);
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.addHeader("Game Settings", 400.0f, 3);
        this.row();
        this.addLabel("Game Name");
        this.addValue(this.nameTextArea).padBottom(this.panelStyle.rowPadding).right().fill();
        this.addValue(this.gameNameRandomizerIcon).size(28.0f, 28.0f).right();
        this.add();
        this.row();
        this.addLabel("Seed", 1);
        this.addValue(this.seedTextArea).right().fill().padRight(6.0f);
        this.addValue(this.seedRandomizerIcon).size(28.0f, 28.0f).right();
        this.row();
        this.addLabel("Difficulty", 1);
        this.addValue(this.difficultyTextSelector).right().colspan(2).fill();
        this.add();
        this.row();
        this.addHeader("Mods", 3);
        this.row();
        this.addValue(this.infoLabel, 3);
        this.pack();
    }

    public GameSettings getGameSettings() {
        GameSettings settings = new GameSettings();
        settings.gameName = this.nameTextArea.getText();
        settings.seed = Integer.parseInt(this.seedTextArea.getText());
        settings.gameDifficulty = this.difficultyTextSelector.getSelectedObject();
        return settings;
    }

    @Override
    public ValidationResult validateForm(ValidationResult validationResult) {
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        if (this.nameTextArea.getText().trim().isEmpty()) {
            validationResult.addMessage(this.componentFactory.translate("menu_newgame_message_name_not_empty"), this.nameTextArea);
            validationResult.status(Form.ValidationStatus.INVALID);
        } else if (this.nameTextArea.getText().length() < 3) {
            validationResult.addMessage(this.componentFactory.translate("menu_newgame_message_name_char_limit"), this.nameTextArea);
            validationResult.status(Form.ValidationStatus.INVALID);
        } else if (this.nameTextArea.getText().length() > 100) {
            validationResult.addMessage(this.componentFactory.translate("menu_newgame_message_name_char_limit"), this.nameTextArea);
            validationResult.status(Form.ValidationStatus.INVALID);
        } else if (!Pattern.matches("^[A-Za-z0-9._ ]{1,100}$", this.nameTextArea.getText())) {
            validationResult.addMessage(this.componentFactory.translate("menu_newgame_message_name_chars"), this.nameTextArea);
            validationResult.status(Form.ValidationStatus.INVALID);
        } else {
            String gameName = this.nameTextArea.getText();
            FileHandle rootPath = Gdx.files.local(AstraXApp.astraX.getActiveUserProfile().resourcePath);
            FileHandle gameDirectory = rootPath.child("saves").child(gameName);
            if (gameDirectory.exists()) {
                validationResult.addMessage(this.componentFactory.translate("menu_newgame_message_game_exists"), this.nameTextArea);
                validationResult.status(Form.ValidationStatus.INVALID);
            }
        }
        if (this.seedTextArea.getText().trim().isEmpty()) {
            validationResult.addMessage(this.componentFactory.translate("menu_newgame_message_empty_seed"), this.seedTextArea);
            validationResult.status(Form.ValidationStatus.INVALID);
        } else {
            String text = this.seedTextArea.getText();
            try {
                Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                validationResult.addMessage(this.componentFactory.translate("menu_newgame_message_only_numbers_seed"), this.seedTextArea);
                validationResult.status(Form.ValidationStatus.INVALID);
            }
        }
        this.markLabels(validationResult);
        return validationResult;
    }

    @Override
    public void resetForm() {
        this.createAndSetRandomGameName();
    }

    @Override
    public void resetValues() {
        this.resetForm();
    }
}

