/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.newgame;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Stack;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.main.SavedGame;
import com.neutronio.astrax.app.repository.UserProfileRepository;
import com.neutronio.astrax.app.screen.MainMenuScreen;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.DefaultFormListener;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.menu.Menu;
import com.neutronio.astrax.ui.commons.widgets.Modal;
import com.neutronio.astrax.ui.commons.widgets.StackController;
import com.neutronio.astrax.ui.editor.Palette;
import com.neutronio.astrax.ui.main.MainSettingsTab;
import com.neutronio.astrax.ui.main.loadgame.SavedGamePicker;
import com.neutronio.astrax.ui.main.newgame.NewGameTab;
import com.neutronio.astrax.ui.main.user.EditUserFormContainer;
import com.neutronio.astrax.ui.main.user.UserOverview;
import com.neutronio.astrax.ui.main.user.UserProfilePicker;
import java.util.Objects;
import java.util.logging.Logger;

public class MainMenuFlowController
implements UserOverview.UserOverviewListener {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private ComponentFactory factory;
    private AstraXApp gameContainer;
    private MainMenuScreen parent;
    private Stack stack;
    private StackController stackController;
    private Menu<Runnable> mainMenu;
    private Menu<Runnable> playMenu;
    private NewGameTab newGameTab;
    private MainSettingsTab settingsTab;
    private SavedGamePicker savedGamePicker;
    private UserOverview userOverview;
    private EditUserFormContainer editUserFormContainer;
    private Modal<EditUserFormContainer> editUserFormContainerModal;
    private UserProfilePicker userPicker;
    private Modal<UserProfilePicker> userPickerModal;

    public MainMenuFlowController(AstraXApp container, ComponentFactory componentFactory, MainMenuScreen mainMenuScreen, Skin skin) {
        UserProfileRepository repository;
        UserProfile userProfile;
        this.factory = componentFactory;
        this.gameContainer = container;
        this.parent = mainMenuScreen;
        this.mainMenu = new Menu(this.factory, "main");
        this.mainMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.showPlayMenu();
            }
        }), this.factory.translate("menu_play"), this.mainMenu.getStyle().buttonStyleName);
        this.mainMenu.row();
        this.mainMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.showUserOverview();
            }
        }), this.factory.translate("menu_users"), this.mainMenu.getStyle().buttonStyleName);
        this.mainMenu.row();
        this.mainMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.showSettings();
            }
        }), this.factory.translate("menu_settings"), this.mainMenu.getStyle().buttonStyleName);
        this.mainMenu.row();
        this.mainMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.gameContainer.getMusicPlayer().dispose();
                Gdx.app.exit();
            }
        }), this.factory.translate("menu_exit_to_desktop"), "menu-red");
        this.mainMenu.row();
        this.mainMenu.pack();
        this.playMenu = new Menu(this.factory, "main");
        this.playMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (AstraXApp.astraX.getActiveUserProfile() == null) {
                    AstraXApp.astraX.showWarningAlert(MainMenuFlowController.this.factory.translate("menu_message_pick_user"));
                } else {
                    MainMenuFlowController.this.showNewGame();
                }
            }
        }), this.factory.translate("menu_newgame"), this.playMenu.getStyle().buttonStyleName);
        this.playMenu.row();
        this.playMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (AstraXApp.astraX.getActiveUserProfile() == null) {
                    AstraXApp.astraX.showWarningAlert(MainMenuFlowController.this.factory.translate("menu_message_pick_user"));
                } else {
                    MainMenuFlowController.this.showLoadGame();
                }
            }
        }), this.factory.translate("menu_load_game"), this.playMenu.getStyle().buttonStyleName);
        this.playMenu.row();
        this.playMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.enterSpacecraftScreen();
            }
        }), componentFactory.translate("menu_spacecraft_editor"), this.playMenu.getStyle().buttonStyleName);
        this.playMenu.row();
        this.playMenu.addButtonForChoice(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.returnToMain();
            }
        }), componentFactory.translate("form_back"), this.playMenu.getStyle().buttonStyleName);
        this.playMenu.row();
        this.userOverview = new UserOverview(this.factory, "default", "outset");
        this.userOverview.setListener(this);
        this.editUserFormContainer = new EditUserFormContainer(this.factory);
        this.editUserFormContainerModal = new Modal<EditUserFormContainer>(this.factory, this.editUserFormContainer);
        this.editUserFormContainerModal.setHeaderIcon("icon_inline_user");
        this.editUserFormContainerModal.setHeaderText(this.factory.translate("menu_user_edit"));
        this.editUserFormContainer.getFormController().addListener(new DefaultFormListener(){

            @Override
            public void onFormSubmit(AbstractForm form) {
                MainMenuFlowController.this.editUserFormContainer.getEditUserPanel().storeInto((UserProfile)MainMenuFlowController.this.userOverview.getProfilePalette().getSelected());
                MainMenuFlowController.this.userOverview.saveProfiles();
                MainMenuFlowController.this.editUserFormContainerModal.hide();
                MainMenuFlowController.this.userPicker.loadCurrentProfiles();
                AstraXApp.astraX.showSuccessAlert(MainMenuFlowController.this.factory.translate("menu_user_message_saved"));
            }

            @Override
            public void onFormCancel(AbstractForm form) {
                MainMenuFlowController.this.editUserFormContainerModal.hide();
            }
        });
        this.userPicker = new UserProfilePicker(componentFactory);
        this.userPicker.loadCurrentProfiles();
        this.userPicker.getUserProfilePickerForm().getProfilePalette().setListener(new Palette.PaletteListener<UserProfile>(){

            @Override
            public void onSelectedChanged(UserProfile selectedItem) {
                ValidationResult result = MainMenuFlowController.this.userPicker.getUserProfilePickerForm().validateForm(new ValidationResult());
                if (result.getStatus().equals((Object)Form.ValidationStatus.VALID)) {
                    UserProfile selectedProfile = MainMenuFlowController.this.userPicker.getSelectedProfile();
                    MainMenuFlowController.this.userPickerModal.hide();
                    AstraXApp.astraX.setActiveUserProfile(selectedProfile);
                    MainMenuFlowController.this.parent.getUserProfilePanel().update(selectedProfile);
                    MainMenuFlowController.this.savedGamePicker.setSavedGames(selectedProfile.savedGames);
                    AstraXApp.astraX.getApplicationSettings().activeUserProfileID = selectedProfile.id;
                    AstraXApp.astraX.saveApplicationData(AstraXApp.astraX.getApplicationSettings());
                } else {
                    AstraXApp.astraX.showErrorAlert(result.getMessages());
                }
            }
        });
        this.userPickerModal = new Modal<UserProfilePicker>(componentFactory, this.userPicker);
        this.userPickerModal.setHeaderText(componentFactory.translate("menu_user_choose"));
        this.userPickerModal.setHeaderIcon("icon_inline_user");
        this.newGameTab = new NewGameTab(componentFactory);
        this.newGameTab.construct();
        this.newGameTab.getStartButton().setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (MainMenuFlowController.this.newGameTab.getValidationStatus().ordinal() == Form.ValidationStatus.VALID.ordinal()) {
                    MainMenuFlowController.this.parent.hideLogoAndHints(CustomAction.get(new Runnable(){

                        @Override
                        public void run() {
                            MainMenuFlowController.this.parent.enterSpaceScreen(MainMenuFlowController.this.newGameTab.getObject());
                        }
                    }));
                }
            }
        }));
        this.newGameTab.getBackButton().setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.showPlayMenu();
            }
        }));
        this.savedGamePicker = new SavedGamePicker(componentFactory);
        this.savedGamePicker.getBackButton().setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.showPlayMenu();
            }
        }));
        this.savedGamePicker.getGamePalette().setListener(new Palette.PaletteListener<SavedGame>(){

            @Override
            public void onSelectedChanged(SavedGame selectedItem) {
                if (selectedItem != null) {
                    MainMenuFlowController.this.parent.loadGame(selectedItem);
                }
            }
        });
        if (AstraXApp.astraX.getApplicationSettings().activeUserProfileID != null && (userProfile = (UserProfile)(repository = AstraXApp.astraX.getRepository(UserProfileRepository.class)).find(AstraXApp.astraX.getApplicationSettings().activeUserProfileID)) != null) {
            AstraXApp.astraX.setActiveUserProfile(userProfile);
            this.parent.getUserProfilePanel().update(userProfile);
            this.userPicker.getUserProfilePickerForm().setSelected(userProfile.id);
            this.savedGamePicker.setSavedGames(userProfile.savedGames);
        }
        this.settingsTab = new MainSettingsTab(componentFactory);
        this.settingsTab.applyStarterValues(this.gameContainer.getApplicationSettings());
        this.parent.getHudStage().addActor(this.settingsTab.getSettingsResetPanelModal());
        this.settingsTab.getMultiFormContainer().getFormController().addListener(new DefaultFormListener(){

            @Override
            public void onFormCancel(AbstractForm form) {
                super.onFormCancel(form);
                MainMenuFlowController.this.returnToMain();
            }

            @Override
            public void onFormAction(AbstractForm form, String action) {
                super.onFormAction(form, action);
                if (Objects.equals(action, "restoreDefault")) {
                    MainMenuFlowController.this.settingsTab.getSettingsResetPanelModal().toFront();
                    MainMenuFlowController.this.settingsTab.showResetModal();
                }
            }

            @Override
            public void onFormReset(AbstractForm form) {
                super.onFormReset(form);
                if (form != null) {
                    form.resetForm();
                }
            }
        });
        this.settingsTab.construct();
        this.stack = new Stack();
        this.stack.add(this.mainMenu);
        this.stack.add(this.playMenu);
        this.stack.add(this.savedGamePicker);
        this.stack.add(this.newGameTab);
        this.stack.add(this.settingsTab);
        this.stack.add(this.userOverview);
        this.stack.pack();
        this.stackController = new StackController(this.stack);
        this.parent.getHudStage().addActor(this.userPickerModal);
        this.parent.getHudStage().addActor(this.editUserFormContainerModal);
    }

    private void enterSpacecraftScreen() {
        this.parent.hideLogoAndHints(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.parent.enterEditor();
            }
        }));
    }

    private AstraXApp getGameContainer() {
        return this.gameContainer;
    }

    public void showNewGame() {
        this.parent.showHeader(this.factory.translate("menu_newgame"));
        this.newGameTab.refreshFolders();
        this.stackController.show(this.newGameTab);
    }

    public void showPlayMenu() {
        this.parent.showHeader(this.factory.translate("menu_play"));
        if (this.parent.isLogoShown()) {
            this.parent.hideLogoAndHints(CustomAction.get(new Runnable(){

                @Override
                public void run() {
                    MainMenuFlowController.this.stackController.show(MainMenuFlowController.this.playMenu);
                }
            }));
        } else {
            this.stackController.show(this.playMenu);
        }
    }

    public void showSettings() {
        this.parent.showHeader(this.factory.translate("game_menu_settings"));
        this.parent.hideLogoAndHints(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.stackController.show(MainMenuFlowController.this.settingsTab);
            }
        }));
    }

    public void showUserPickerModal() {
        this.userPicker.loadCurrentProfiles();
        this.userPickerModal.toFront();
        this.userPickerModal.show();
    }

    public void showUserOverview() {
        this.parent.showHeader(this.factory.translate("menu_users"));
        this.userOverview.loadCurrentProfiles();
        this.parent.hideLogoAndHints(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                MainMenuFlowController.this.stackController.show(MainMenuFlowController.this.userOverview);
            }
        }));
    }

    public void showLoadGame() {
        this.parent.showHeader(this.factory.translate("menu_load_game"));
        this.stackController.show(this.savedGamePicker);
    }

    public void returnToMain() {
        this.parent.hideHeader();
        this.parent.showLogoAndHints();
        this.stackController.show(this.mainMenu);
        if (this.userPicker.getSelectedProfile() != null) {
            this.parent.getUserProfilePanel().update(this.userPicker.getSelectedProfile());
            this.savedGamePicker.setSavedGames(this.userPicker.getSelectedProfile().savedGames);
        }
    }

    public Stack getStack() {
        return this.stack;
    }

    public UserOverview getUserOverview() {
        return this.userOverview;
    }

    public UserProfilePicker getUserPicker() {
        return this.userPicker;
    }

    @Override
    public void onBackFromUserOverview() {
        this.returnToMain();
    }

    @Override
    public void onEditFromUserOverview(UserProfile toEdit) {
        this.editUserFormContainer.getEditUserPanel().updateWith(toEdit);
        this.editUserFormContainerModal.show();
        this.editUserFormContainerModal.toFront();
    }

    public void reset() {
        this.newGameTab.resetForms();
    }
}

