/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.newgame;

import com.neutronio.astrax.app.datapack.game.GameSettings;
import com.neutronio.astrax.app.datapack.game.world.PlayerSettings;
import com.neutronio.astrax.app.datapack.game.world.WorldSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxySettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.TabbedForm;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.main.newgame.GalaxyPanel;
import com.neutronio.astrax.ui.main.newgame.GamePanel;
import com.neutronio.astrax.ui.main.newgame.SpacecraftPanel;
import com.neutronio.astrax.ui.main.newgame.WorldGenerationPanel;
import java.util.ArrayList;
import java.util.List;

public class NewGameTab
extends TabbedForm<GameSettings> {
    private GamePanel gamePanel;
    private SpacecraftPanel spacecraftPanel;
    private GalaxyPanel galaxyPanel;
    private WorldGenerationPanel worldGenerationPanel;
    private List<GroupFormListener<GameSettings>> listeners = new ArrayList<GroupFormListener<GameSettings>>();

    public NewGameTab(ComponentFactory factory) {
        super(factory, "secondary", null);
        this.gamePanel = new GamePanel(this.componentFactory, this.componentFactory.getSkin());
        this.gamePanel.construct();
        this.gamePanel.align(2);
        this.spacecraftPanel = new SpacecraftPanel(this.componentFactory);
        this.spacecraftPanel.construct();
        this.spacecraftPanel.align(2);
        this.galaxyPanel = new GalaxyPanel(this.componentFactory);
        this.galaxyPanel.construct();
        this.galaxyPanel.align(2);
        this.worldGenerationPanel = new WorldGenerationPanel(this.componentFactory);
        this.worldGenerationPanel.construct();
        this.worldGenerationPanel.align(2);
        this.addForm("Game", this.gamePanel);
        this.addForm("World", this.worldGenerationPanel);
        this.addForm("Galaxy", this.galaxyPanel);
        this.addForm("Player", this.spacecraftPanel);
    }

    public void resetForms() {
        this.gamePanel.resetForm();
        this.worldGenerationPanel.resetForm();
        this.galaxyPanel.resetForm();
        this.spacecraftPanel.resetForm();
    }

    public void refreshFolders() {
        this.spacecraftPanel.refreshFolders();
    }

    @Override
    public GameSettings getObject() {
        GameSettings gameSettings = this.gamePanel.getGameSettings();
        PlayerSettings playerSettings = this.spacecraftPanel.getPlayerSettings();
        GalaxySettings galaxySettings = this.galaxyPanel.getGalaxySettings();
        galaxySettings.galaxyDistributionSettings = this.worldGenerationPanel.getGalaxyGenerationSettings();
        WorldSettings worldSettings = new WorldSettings();
        worldSettings.setGalaxySettings(galaxySettings);
        worldSettings.setPlayerSettings(playerSettings);
        gameSettings.worldSettings = worldSettings;
        return gameSettings;
    }

    public static interface GroupFormListener<OUTPUT> {
        public void onBack();

        public void onValidate(ValidationResult var1);

        public void onFinished(OUTPUT var1);
    }
}

