/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.newgame;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.datapack.game.world.PlayerSettings;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteFactory;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteGrid;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.SatelliteRole;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.VesselSize;
import com.neutronio.astrax.editor.checklist.SpaceshipValidator;
import com.neutronio.astrax.gfx.SatelliteGraphics;
import com.neutronio.astrax.gfx.entities.GraphicsContainer;
import com.neutronio.astrax.gfx.factories.SatelliteGraphicsFactory;
import com.neutronio.astrax.io.AstraXFiles;
import com.neutronio.astrax.io.BlueprintLoader;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.text.AstraXLabel;
import com.neutronio.astrax.ui.commons.widgets.Modal;
import com.neutronio.astrax.ui.files.FileDialog;
import com.neutronio.astrax.ui.files.FileDialogForm;
import java.io.IOException;
import java.util.Date;
import java.util.logging.Logger;

public class SpacecraftPanel
extends AbstractForm {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private String originFolder = "userdata/spacecraft";
    private TextArea spacecraftNameValue;
    private AstraXButton spacecraftNameRandomizerIcon;
    private FileDialogForm fileDialog;
    private Modal<FileDialogForm> fileDialogModal;
    public AstraXTextButton chooseSpacecraft;
    public AstraXLabel chooseSpacecraftLabel;
    private BlueprintLoader blueprintLoader = new BlueprintLoader();
    private SpaceshipValidator spaceshipValidator = new SpaceshipValidator();
    private SatelliteGrid loadedSpacecraft;
    private SatelliteGraphics satelliteGraphics;
    private GraphicsContainer<SatelliteGraphics> graphicsContainer;
    private SatelliteFactory satelliteFactory = AstraXApp.astraX.getFactoryByClass(SatelliteFactory.class);
    private SimplePanel satelliteData;
    private AstraXFiles.AstraXFile satelliteFile;

    public SpacecraftPanel(ComponentFactory componentFactory) {
        super(componentFactory, "newgame", "outset");
        this.satelliteFactory.setSeed(new Date().getTime());
        this.spacecraftNameRandomizerIcon = new AstraXButton(componentFactory, "icon_inline_dice", "primary");
        this.spacecraftNameRandomizerIcon.setCanCheck(false);
        this.spacecraftNameRandomizerIcon.addListener(componentFactory.getButtonSoundListener("dice"));
        this.spacecraftNameRandomizerIcon.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                SpacecraftPanel.this.spacecraftNameValue.setText(SpacecraftPanel.this.satelliteFactory.generateName());
            }
        });
        this.fileDialog = new FileDialogForm(componentFactory, "window-body");
        this.fileDialog.setMode(1);
        this.fileDialog.setOriginFolder(this.originFolder);
        this.fileDialogModal = new Modal<FileDialogForm>(componentFactory, this.fileDialog);
        this.fileDialogModal.setHeaderText(this.getTranslation("menu_newgame_spacecraft_load"));
        this.graphicsContainer = new GraphicsContainer();
        this.graphicsContainer.setOrigin(1);
        this.satelliteData = new SimplePanel(componentFactory);
        this.spacecraftNameValue = new TextArea("", componentFactory.getSkin());
        this.spacecraftNameValue.setPrefRows(1.0f);
        this.spacecraftNameValue.setText(this.satelliteFactory.generateName());
        this.chooseSpacecraft = componentFactory.getTextButton("primary", this.getTranslation("form_load"), "secondary");
        this.chooseSpacecraft.setCanCheck(false);
        this.chooseSpacecraftLabel = this.getLabel("-");
        this.chooseSpacecraftLabel.setEllipsis(true);
        this.chooseSpacecraft.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                if (event.getTarget() != null && !SpacecraftPanel.this.fileDialogModal.hasParent()) {
                    event.getTarget().getStage().addActor(SpacecraftPanel.this.fileDialogModal);
                }
                SpacecraftPanel.this.fileDialogModal.show();
            }
        });
        this.fileDialog.setListener(new FileDialog.FileDialogListener(){

            @Override
            public void onFileLoad(AstraXFiles.AstraXFile file) {
                if (file == null) {
                    return;
                }
                SpacecraftPanel.this.logger.fine("Loading spacecraft into editor... ");
                try {
                    SpacecraftPanel.this.satelliteFile = file;
                    SpacecraftPanel.this.spaceshipValidator = new SpaceshipValidator();
                    SpacecraftPanel.this.loadedSpacecraft = SpacecraftPanel.this.blueprintLoader.load(file);
                    SpacecraftPanel.this.chooseSpacecraftLabel.setText(((SpacecraftPanel)SpacecraftPanel.this).loadedSpacecraft.name);
                    SpacecraftPanel.this.fileDialogModal.hide();
                    SatelliteGraphicsFactory graphicsFactory = AstraXApp.astraX.getFactoryByClass(SatelliteGraphicsFactory.class);
                    SpacecraftPanel.this.satelliteGraphics = graphicsFactory.createGraphics(SpacecraftPanel.this.loadedSpacecraft);
                    SpacecraftPanel.this.graphicsContainer.setGraphics(SpacecraftPanel.this.satelliteGraphics);
                    SpacecraftPanel.this.graphicsContainer.setSize(SpacecraftPanel.this.satelliteGraphics.getWidth(), SpacecraftPanel.this.satelliteGraphics.getHeight());
                }
                catch (IOException e) {
                    SpacecraftPanel.this.logger.severe("Could not read Spacecraft");
                    e.printStackTrace();
                }
            }

            @Override
            public void onFileSaved(String basePath, String filename) {
                throw new UnsupportedOperationException("Not supposed to be called here!");
            }

            @Override
            public void onFileDelete(AstraXFiles.AstraXFile file) {
            }

            @Override
            public void onBack() {
                SpacecraftPanel.this.fileDialogModal.hide();
            }
        });
    }

    public Modal<FileDialogForm> getFileDialogModal() {
        return this.fileDialogModal;
    }

    public PlayerSettings getPlayerSettings() {
        PlayerSettings playerSettings = new PlayerSettings();
        playerSettings.playerName = AstraXApp.astraX.getActiveUserProfile().playerName;
        playerSettings.shipName = this.spacecraftNameValue.getText();
        playerSettings.satelliteGrid = this.loadedSpacecraft;
        playerSettings.satelliteGridFile = this.satelliteFile;
        return playerSettings;
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.satelliteData.clear();
        this.satelliteData.row();
        this.satelliteData.addLabel(this.getTranslation("menu_newgame_spacecraft_type"), 1);
        this.satelliteData.addValue(this.chooseSpacecraftLabel).width(this.panelStyle.minValueWidth);
        this.satelliteData.addValue(this.chooseSpacecraft);
        this.satelliteData.row();
        this.satelliteData.addLabel(this.getTranslation("menu_newgame_spacecraft_name"));
        this.satelliteData.addValue(this.spacecraftNameValue).width(this.panelStyle.minValueWidth);
        this.satelliteData.addValueCentered(this.spacecraftNameRandomizerIcon, 1);
        this.satelliteData.getCell(this.spacecraftNameRandomizerIcon).left();
        this.satelliteData.row();
        this.satelliteData.pack();
        AstraXLabel spacecraftHeader = this.getHeader("Spacecraft");
        this.addValue(spacecraftHeader).fillX();
        this.row();
        this.add(this.graphicsContainer).minSize(VesselSize.LARGE.width * 16, VesselSize.LARGE.height * 16).center().padBottom(this.panelStyle.rowPadding).padRight(this.panelStyle.columnPadding);
        this.row();
        this.addValue(this.satelliteData, 1);
        this.pack();
    }

    @Override
    public ValidationResult validateForm(ValidationResult validationResult) {
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        if (this.spacecraftNameValue.getText().trim().isEmpty()) {
            validationResult.addMessage(this.getTranslation("menu_newgame_spacecraft_message_missing_name"), this.spacecraftNameValue);
            validationResult.status(Form.ValidationStatus.INVALID);
        }
        if (this.loadedSpacecraft == null) {
            validationResult.addMessage(this.getTranslation("menu_newgame_spacecraft_message_missing_spacecraft"), this.spacecraftNameValue);
            validationResult.status(Form.ValidationStatus.INVALID);
        } else {
            if (this.loadedSpacecraft.vesselRole.equals((Object)SatelliteRole.STATION)) {
                validationResult.addMessage(this.getTranslation("menu_newgame_spacecraft_message_no_station"), this.chooseSpacecraftLabel);
                validationResult.status(Form.ValidationStatus.INVALID);
            }
            this.spaceshipValidator.validateAll(this.loadedSpacecraft);
            if (this.spaceshipValidator.getValidationState().ordinal() > Message.MessageType.WARNING.ordinal()) {
                validationResult.addMessage(this.getTranslation("menu_newgame_spacecraft_message_cant_use_spacecraft"), this.chooseSpacecraftLabel);
                validationResult.status(Form.ValidationStatus.INVALID);
            }
        }
        this.markLabels(validationResult);
        return validationResult;
    }

    public void refreshFolders() {
        this.fileDialog.setOriginFolder(this.originFolder);
    }

    @Override
    public void resetForm() {
        this.refreshFolders();
    }

    @Override
    public void resetValues() {
    }
}

