/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.newgame;

import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.neutronio.astrax.app.datapack.game.world.galaxy.GalaxyDistributionSettings;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.IconLabel;
import com.neutronio.astrax.ui.commons.buttons.StaticIcon;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.text.TextSlider;
import com.neutronio.astrax.ui.commons.widgets.TooltipContent;
import com.neutronio.astrax.util.StandardFormats;
import java.util.ArrayList;
import java.util.List;

public class WorldGenerationPanel
extends AbstractForm {
    private static String[] tags = new String[]{"starsystem", "nebula", "planet", "gaseous", "asteroid", "habitable", "station", "trader"};
    private static String labelIdentifier = "game_tag_%s_label";
    private static String descriptionIdentifier = "game_tag_%s_description";
    private IconLabel infoLabel;
    private List<TextSlider> sliders = new ArrayList<TextSlider>();

    public WorldGenerationPanel(ComponentFactory componentFactory) {
        super(componentFactory, "newgame", "outset");
        this.infoLabel = new IconLabel(componentFactory, "warning");
        this.infoLabel.setText("Density of 1 means no change.\nChoose >1 for increased and <1 for decreased density\nThese settings may affect general difficulty.");
        for (String tag : tags) {
            TextSlider slider = new TextSlider(componentFactory);
            slider.setBaseValue(3.0f);
            slider.setFormat(StandardFormats.FLOAT_COUNT);
            slider.setValue(0.3333333f);
            slider.align(8);
            this.sliders.add(slider);
        }
    }

    @Override
    public void construct() {
        this.clear();
        super.construct();
        this.addHeader("World Gen Settings", 400.0f, 3);
        this.row();
        this.addValue(this.infoLabel, 2);
        this.row();
        int i2 = 0;
        for (String tag : tags) {
            String displayName = this.componentFactory.translate(String.format(labelIdentifier, tag));
            String description = this.componentFactory.translate(String.format(descriptionIdentifier, tag));
            StaticIcon icon = new StaticIcon(this.componentFactory.getSkin(), "primary-round-28x28");
            icon.setInlineIcon("icon_inline_info");
            TooltipContent tooltipContent = new TooltipContent(description, this.componentFactory.getSkin());
            icon.addListener(new Tooltip<TooltipContent>(tooltipContent));
            this.addRow(displayName, this.sliders.get(i2), 1);
            this.add(icon);
            this.row();
            ++i2;
        }
        this.pack();
    }

    @Override
    public ValidationResult validateForm(ValidationResult validationResult) {
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        this.markLabels(validationResult);
        return validationResult;
    }

    public GalaxyDistributionSettings getGalaxyGenerationSettings() {
        GalaxyDistributionSettings settings = new GalaxyDistributionSettings();
        int i2 = 0;
        for (TextSlider slider : this.sliders) {
            settings.addDistributionParameter(tags[i2], slider.getValue() * slider.getBaseValue());
            ++i2;
        }
        return settings;
    }

    @Override
    public void resetForm() {
        for (TextSlider slider : this.sliders) {
            slider.setValue(0.3333f);
        }
    }

    @Override
    public void resetStyles() {
    }

    @Override
    public void resetValues() {
    }
}

