/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.user;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.datapack.NameFactory;
import com.neutronio.astrax.io.files.FileUtils;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.DressupAvatarPanel;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import java.io.IOException;
import java.util.Random;

public class EditUserForm
extends AbstractForm {
    String[] nameGenPatterns = new String[]{"english-names-male english-surnames", "english-names-female english-surnames", "english-names-neutral english-surnames"};
    private SimplePanel headerPanel;
    private NumberGenerator numberGenerator;
    private TextField nameValue;
    private AstraXButton nameRandomizerIcon;
    private TextField pathValue;
    private AstraXButton openFolder;
    private DressupAvatarPanel dressupAvatarPanel;

    public EditUserForm(ComponentFactory componentFactory) {
        super(componentFactory, "default", null);
        this.nameValue = new TextField("", componentFactory.getSkin());
        this.nameValue.setProgrammaticChangeEvents(false);
        this.nameValue.removeListener(this.nameValue.getDefaultInputListener());
        this.nameValue.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                event.setBubbles(false);
            }
        });
        this.nameValue.setDisabled(false);
        this.nameValue.addListener(this.nameValue.getDefaultInputListener());
        this.numberGenerator = new NumberGenerator(new Random().nextLong());
        this.nameRandomizerIcon = new AstraXButton(componentFactory, "icon_inline_dice", "primary");
        this.nameRandomizerIcon.setCanCheck(false);
        this.nameRandomizerIcon.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                String randomPattern = EditUserForm.this.numberGenerator.getRandomEntry(EditUserForm.this.nameGenPatterns);
                String charName = AstraXApp.astraX.getFactoryByClass(NameFactory.class).createName(EditUserForm.this.numberGenerator, randomPattern);
                EditUserForm.this.nameValue.setText(charName);
            }
        }));
        this.pathValue = new TextField("", componentFactory.getSkin());
        this.pathValue.setDisabled(true);
        this.openFolder = new AstraXButton(componentFactory, "icon_inline_folder", "primary");
        this.openFolder.setCanCheck(false);
        this.openFolder.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtils.openInFileBrowser(EditUserForm.this.pathValue.getText());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }));
        this.dressupAvatarPanel = new DressupAvatarPanel(componentFactory);
        this.headerPanel = new SimplePanel(componentFactory);
        this.headerPanel.addRow("Name", this.nameValue);
        this.headerPanel.addValueCentered(this.nameRandomizerIcon).size(28.0f, 28.0f).left();
        this.headerPanel.row();
        this.headerPanel.addRow("Path", this.pathValue);
        this.headerPanel.addValueCentered(this.openFolder).size(28.0f, 28.0f).left();
        this.headerPanel.pack();
        super.construct();
        this.addValue(this.headerPanel).left();
        this.row();
        this.addValueCentered(this.dressupAvatarPanel);
        this.pack();
    }

    public void storeInto(UserProfile userProfile) {
        userProfile.playerName = this.nameValue.getText();
        userProfile.resourcePath = this.pathValue.getText();
        userProfile.avatarTextureIndices = this.dressupAvatarPanel.getTextureIndices();
        userProfile.avatarColorIndices = this.dressupAvatarPanel.getColorIndices();
    }

    public void updateWith(UserProfile userProfile) {
        this.nameValue.setText(userProfile.playerName);
        this.pathValue.setText(userProfile.resourcePath);
        this.dressupAvatarPanel.setIndices(userProfile.avatarTextureIndices, userProfile.avatarColorIndices);
        this.dressupAvatarPanel.updateAvatar();
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        if (this.nameValue.getText().isEmpty()) {
            result.addMessage("Name cannot be empty!", this.nameValue);
            result.status(Form.ValidationStatus.INVALID);
        }
        return result;
    }

    @Override
    public void resetForm() {
    }

    @Override
    public void resetValues() {
    }
}

