/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.user;

import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.Message;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.UserProfileFactory;
import com.neutronio.astrax.app.repository.UserProfileRepository;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.buttons.AstraXTextButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;
import com.neutronio.astrax.ui.commons.widgets.dialog.DialogBox;
import com.neutronio.astrax.ui.main.UserProfilePalette;
import java.util.List;

public class UserOverview
extends SimplePanel
implements DialogBox.DialogBoxListener {
    private AstraXButton addProfileButton;
    private AstraXButton deleteProfileButton;
    private AstraXButton editProfileButton;
    private AstraXTextButton backButton;
    private UserProfilePalette profilePalette;
    private PaginatorComponent paginatorComponent;
    private UserProfileRepository userProfileRepository = AstraXApp.astraX.getRepository(UserProfileRepository.class);
    private UserProfileFactory userProfileFactory = AstraXApp.astraX.getAppFactoryByClass(UserProfileFactory.class);
    private UserOverviewListener listener;

    public UserOverview(final ComponentFactory componentFactory, String style, String backgroundStyle) {
        super(componentFactory, style, backgroundStyle);
        this.profilePalette = new UserProfilePalette(componentFactory);
        this.profilePalette.setIconCount(6);
        this.profilePalette.setColumns(2);
        this.profilePalette.fillWithButtons("outset-button");
        this.paginatorComponent = new PaginatorComponent(componentFactory);
        this.paginatorComponent.setPaginator(this.profilePalette);
        this.backButton = new AstraXTextButton(componentFactory, "primary");
        this.backButton.setText(componentFactory.translate("form_back"));
        this.backButton.setCanCheck(false);
        this.backButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (UserOverview.this.getListener() != null) {
                    UserOverview.this.getListener().onBackFromUserOverview();
                }
            }
        }));
        this.addProfileButton = new AstraXButton(componentFactory, "primary-no-check");
        this.addProfileButton.setInlineIcon(componentFactory.getSkin().getDrawable("icon_inline_plus"));
        this.addProfileButton.setCanCheck(false);
        this.addProfileButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                AstraXApp.astraX.showSuccessAlert(componentFactory.translate("menu_user_message_created"));
                UserProfile newUser = UserOverview.this.userProfileFactory.createUserProfile("New User");
                UserOverview.this.userProfileFactory.addUserProfileToRepository(newUser);
                UserOverview.this.userProfileFactory.saveUserRepository();
                UserOverview.this.userProfileFactory.createFoldersOnDisk(newUser);
                UserOverview.this.loadCurrentProfiles();
            }
        }));
        this.deleteProfileButton = new AstraXButton(componentFactory, "control-red");
        this.deleteProfileButton.setInlineIcon(componentFactory.getSkin().getDrawable("icon_inline_trash"));
        this.deleteProfileButton.setCanCheck(false);
        this.deleteProfileButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                UserProfile selected = (UserProfile)UserOverview.this.profilePalette.getSelected();
                if (selected != null) {
                    String message = componentFactory.translate("dialog_question_delete", selected.playerName) + "\n\n" + componentFactory.translate("dialog_question_delete_data");
                    AstraXApp.astraX.showDialogBox(new Message(Message.MessageType.WARNING, message), (DialogBox.DialogBoxListener)UserOverview.this);
                }
            }
        }));
        this.editProfileButton = new AstraXButton(componentFactory, "primary-no-check");
        this.editProfileButton.setInlineIcon(componentFactory.getSkin().getDrawable("icon_inline_edit"));
        this.editProfileButton.setCanCheck(false);
        this.editProfileButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                if (UserOverview.this.getListener() != null && UserOverview.this.profilePalette.getSelected() != null) {
                    UserOverview.this.getListener().onEditFromUserOverview((UserProfile)UserOverview.this.profilePalette.getSelected());
                }
            }
        }));
        Table buttonGroup = new Table();
        buttonGroup.align(8);
        buttonGroup.add(this.addProfileButton).padRight(10.0f);
        buttonGroup.add(this.editProfileButton).padRight(15.0f);
        buttonGroup.add(this.deleteProfileButton);
        buttonGroup.pack();
        this.addValue(this.profilePalette, 2).fill();
        this.row();
        this.addValue(buttonGroup);
        this.addValue(this.paginatorComponent).fill().padBottom(30.0f);
        this.row();
        this.addValue(this.backButton).fill(false).left();
        this.pack();
    }

    public void addNewUserProfile(UserProfile userProfile) {
        this.profilePalette.addItem(userProfile);
    }

    public UserProfilePalette getProfilePalette() {
        return this.profilePalette;
    }

    private UserOverviewListener getListener() {
        return this.listener;
    }

    public void setListener(UserOverviewListener listener) {
        this.listener = listener;
    }

    public void loadCurrentProfiles() {
        List allUsers = this.userProfileRepository.all();
        this.profilePalette.clearItems();
        for (UserProfile user : allUsers) {
            this.profilePalette.addItem(user);
        }
        this.profilePalette.updateToContent();
        this.paginatorComponent.update();
    }

    public void saveProfiles() {
        this.userProfileFactory.saveUserRepository();
        this.loadCurrentProfiles();
    }

    @Override
    public void onProceed() {
        UserProfile selected = (UserProfile)this.profilePalette.getSelected();
        this.userProfileRepository.remove(selected.id);
        this.userProfileFactory.deleteFolderFromDisk(selected);
        this.userProfileFactory.saveUserRepository();
        this.loadCurrentProfiles();
        AstraXApp.astraX.showSuccessAlert(this.componentFactory.translate("menu_user_message_removed_success"));
    }

    @Override
    public void onCancel() {
    }

    public static interface UserOverviewListener {
        public void onBackFromUserOverview();

        public void onEditFromUserOverview(UserProfile var1);
    }
}

