/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.user;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.UserProfileFactory;
import com.neutronio.astrax.app.repository.UserProfileRepository;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.action.CustomAction;
import com.neutronio.astrax.ui.commons.buttons.AstraXButton;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.ListComponent;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.commons.widgets.dialog.DialogBox;
import com.neutronio.astrax.ui.main.user.EditUserForm;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class UserPanel
extends SimplePanel
implements DialogBox.DialogBoxListener {
    UserProfileFactory userProfileFactory;
    UserProfileRepository userProfileRepository;
    ListComponent<UserProfile> userList;
    EditUserForm editUserForm;
    AstraXButton addNewProfileButton;
    AstraXButton removeProfileButton;
    List<UserProfile> usersNotSaved = new ArrayList<UserProfile>();

    public UserPanel(ComponentFactory componentFactory) {
        super(componentFactory);
        this.userProfileRepository = AstraXApp.astraX.getRepository(UserProfileRepository.class);
        this.userProfileFactory = AstraXApp.astraX.getAppFactoryByClass(UserProfileFactory.class);
        int rowCount = ComponentFactory.SECONDARY_TAB_HEIGHT / 40;
        this.userList = new ListComponent(componentFactory, rowCount);
        this.userList.align(2);
        this.userList.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                UserProfile selected = UserPanel.this.userList.getSelectedElement();
                if (selected != null) {
                    UserPanel.this.updateWith(selected);
                }
            }
        });
        this.addNewProfileButton = new AstraXButton(componentFactory, "icon_inline_plus", "control-green");
        this.addNewProfileButton.setCanCheck(false);
        this.addNewProfileButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                UserProfile newUser = UserPanel.this.getUserProfileFactory().createUserProfile("New User");
                UserPanel.this.getUserProfileFactory().addUserProfileToRepository(newUser);
                UserPanel.this.getUserProfileFactory().createFoldersOnDisk(newUser);
                UserPanel.this.refreshUsers();
                UserPanel.this.usersNotSaved.add(newUser);
            }
        }));
        this.removeProfileButton = new AstraXButton(componentFactory, "icon_inline_trash", "control-red");
        this.removeProfileButton.setCanCheck(false);
        this.removeProfileButton.setButtonAction(CustomAction.get(new Runnable(){

            @Override
            public void run() {
                UserProfile selected = UserPanel.this.userList.getSelectedElement();
                if (selected != null) {
                    AstraXApp.astraX.showDialogBox("Are you sure you want to delete this profile and all its contents?", (DialogBox.DialogBoxListener)UserPanel.this);
                }
            }
        }));
        HorizontalGroup buttonControlGroup = new HorizontalGroup();
        buttonControlGroup.space(10.0f);
        buttonControlGroup.addActor(this.addNewProfileButton);
        buttonControlGroup.addActor(this.removeProfileButton);
        buttonControlGroup.align(8);
        buttonControlGroup.pack();
        this.editUserForm = new EditUserForm(componentFactory);
        this.editUserForm.align(2);
        super.construct();
        this.addValue(this.userList, 1);
        this.getCell(this.userList).top().fill();
        this.addValue(this.editUserForm, 1);
        this.getCell(this.editUserForm).top().expand();
        this.row();
        this.addValue(buttonControlGroup, 2);
        this.getCell(this.userList).maxWidth(this.editUserForm.getWidth());
        this.getCell(this.editUserForm).maxWidth(400.0f).padLeft(10.0f);
        this.refreshUsers();
    }

    public void saveAllUsers() {
        if (this.userList.getSelectedElement() != null) {
            this.editUserForm.storeInto(this.userList.getSelectedElement());
        }
        this.getUserProfileFactory().saveUserRepository();
        this.refreshUsers();
        this.usersNotSaved.clear();
    }

    public void cleanupDirectories() {
        for (UserProfile notSavedUsers : this.usersNotSaved) {
            this.getUserProfileFactory().deleteFolderFromDisk(notSavedUsers);
            this.userProfileRepository.remove(notSavedUsers.id);
        }
    }

    public void refreshUsers() {
        List profiles = this.userProfileRepository.all();
        this.userList.setElements(SelectBoxWrapper.wrap(profiles));
        this.pack();
    }

    public void updateWith(UserProfile userProfile) {
        this.editUserForm.updateWith(userProfile);
    }

    private UserProfileFactory getUserProfileFactory() {
        return this.userProfileFactory;
    }

    private UserProfileRepository getUserProfileRepository() {
        return this.userProfileRepository;
    }

    @Override
    public void onProceed() {
        UserProfile selected = this.userList.getSelectedElement();
        this.usersNotSaved.remove(selected);
        this.getUserProfileFactory().deleteFolderFromDisk(selected);
        this.getUserProfileFactory().removeUserProfileFromRepository(selected.id);
        this.refreshUsers();
        AstraXApp.astraX.showSuccessAlert("User deleted! Press Apply to save changes");
    }

    @Override
    public void onCancel() {
    }
}

