/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.main.user;

import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.UserProfile;
import com.neutronio.astrax.app.repository.UserProfileRepository;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.widgets.PaginatorComponent;
import com.neutronio.astrax.ui.main.UserProfilePalette;
import java.util.List;
import java.util.Objects;

public class UserProfilePickerForm
extends AbstractForm {
    private UserProfileRepository userProfileRepository = AstraXApp.astraX.getRepository(UserProfileRepository.class);
    private UserProfilePalette profilePalette;
    private PaginatorComponent paginatorComponent;

    public UserProfilePickerForm(ComponentFactory componentFactory) {
        super(componentFactory);
        this.profilePalette = new UserProfilePalette(componentFactory);
        this.profilePalette.setIconCount(6);
        this.profilePalette.setColumns(2);
        this.profilePalette.fillWithButtons("outset-button");
        this.paginatorComponent = new PaginatorComponent(componentFactory);
        this.paginatorComponent.setPaginator(this.profilePalette);
        this.addLabel(this.getTranslation("menu_user_hint"));
        this.row();
        this.addValue(this.profilePalette).fill();
        this.row();
        this.addValue(this.paginatorComponent).fill();
    }

    public void setSelected(String id) {
        for (UserProfile content : this.profilePalette.getContent()) {
            if (!Objects.equals(content.id, id)) continue;
            this.profilePalette.setSelected(content);
        }
    }

    public UserProfilePalette getProfilePalette() {
        return this.profilePalette;
    }

    public void loadCurrentProfiles() {
        List allUsers = this.userProfileRepository.all();
        this.profilePalette.clearItems();
        for (UserProfile user : allUsers) {
            this.profilePalette.addItem(user, null);
        }
        this.profilePalette.updateToContent();
    }

    public UserProfile getSelectedProfile() {
        return (UserProfile)this.profilePalette.getSelected();
    }

    @Override
    public void resetValues() {
        this.profilePalette.deselect();
        this.componentFactory.playUISound("retract");
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        if (this.profilePalette.getSelected() == null) {
            result.addMessage("Please select a user profile!");
            result.status(Form.ValidationStatus.INVALID);
        }
        return result;
    }

    @Override
    public void resetForm() {
        this.profilePalette.deselect();
        this.componentFactory.playUISound("retract");
    }
}

