/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.test;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.gfx.particles.AnimatedParticleEmitter;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;
import com.neutronio.astrax.ui.commons.widgets.SelectBoxWrapper;
import com.neutronio.astrax.ui.commons.widgets.SliderText;
import java.util.Objects;

public class ParticleForm
extends AbstractForm {
    TextField idField;
    SelectBox<SelectBoxWrapper<Array<TextureAtlas.AtlasRegion>>> textureRegion;
    SliderText particleAmount;
    SliderText emissionRate;
    SliderText maxLife;
    SliderText minLife;
    SliderText maxVelocity;
    SliderText minVelocity;
    SliderText maxAngularVelocity;
    SliderText minAngularVelocity;
    SliderText maxSpread;
    SliderText minSpread;
    SliderText maxDelay;
    SliderText minDelay;
    SliderText maxDirection;
    SliderText minDirection;
    Button continuous;
    ParticleFormListener listener;

    public ParticleForm(ComponentFactory componentFactory) {
        super(componentFactory);
        TextureAtlas coreAtlas = AstraXApp.astraX.getCoreDataPack().getTextureAtlas();
        this.textureRegion = new SelectBox(componentFactory.getSkin());
        this.textureRegion.setItems(new SelectBoxWrapper<Array<TextureAtlas.AtlasRegion>>("env/asteroid_particle", coreAtlas.findRegions("env/asteroid_particle")), new SelectBoxWrapper<Array<TextureAtlas.AtlasRegion>>("env/particle_rock", coreAtlas.findRegions("env/particle_rock")), new SelectBoxWrapper<Array<TextureAtlas.AtlasRegion>>("env/particle_circular", coreAtlas.findRegions("env/particle_circular")), new SelectBoxWrapper<Array<TextureAtlas.AtlasRegion>>("env/particle_explosion", coreAtlas.findRegions("env/particle_explosion")), new SelectBoxWrapper<Array<TextureAtlas.AtlasRegion>>("env/particle_smoke", coreAtlas.findRegions("env/particle_smoke")), new SelectBoxWrapper<Array<TextureAtlas.AtlasRegion>>("env/particle_smoke_small", coreAtlas.findRegions("env/particle_smoke_small")), new SelectBoxWrapper<Array<TextureAtlas.AtlasRegion>>("env/particle_spark", coreAtlas.findRegions("env/particle_spark")));
        this.textureRegion.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                if (ParticleForm.this.getListener() != null) {
                    ParticleForm.this.getListener().onTextureChanged(ParticleForm.this.textureRegion.getSelected().getPayload());
                }
            }
        });
        this.particleAmount = new SliderText(componentFactory.getSkin(), 5.0f, 200.0f, 1.0f);
        this.emissionRate = new SliderText(componentFactory.getSkin(), 0.5f, 20.0f, 0.5f);
        this.maxLife = new SliderText(componentFactory.getSkin(), 0.5f, 10.0f, 0.1f);
        this.minLife = new SliderText(componentFactory.getSkin(), 0.5f, 10.0f, 0.1f);
        this.maxVelocity = new SliderText(componentFactory.getSkin(), 0.5f, 70.0f, 0.1f);
        this.minVelocity = new SliderText(componentFactory.getSkin(), 0.5f, 70.0f, 0.1f);
        this.maxAngularVelocity = new SliderText(componentFactory.getSkin(), 0.0f, 50.0f, 1.0f);
        this.minAngularVelocity = new SliderText(componentFactory.getSkin(), 0.0f, 50.0f, 1.0f);
        this.maxSpread = new SliderText(componentFactory.getSkin(), 0.0f, 2.0f, 0.1f);
        this.minSpread = new SliderText(componentFactory.getSkin(), 0.0f, 2.0f, 0.1f);
        this.maxDirection = new SliderText(componentFactory.getSkin(), 0.0f, 360.0f, 0.1f);
        this.minDirection = new SliderText(componentFactory.getSkin(), 0.0f, 360.0f, 0.11f);
        this.maxDelay = new SliderText(componentFactory.getSkin(), 1.0f, 10.0f, 1.0f);
        this.minDelay = new SliderText(componentFactory.getSkin(), 1.0f, 10.0f, 1.0f);
        this.continuous = componentFactory.getCheckBox();
    }

    public ParticleFormListener getListener() {
        return this.listener;
    }

    public void setListener(ParticleFormListener listener) {
        this.listener = listener;
    }

    @Override
    public void construct() {
        this.addRow("Texture", this.textureRegion);
        this.row();
        this.addRow("Particles", this.particleAmount);
        this.row();
        this.addRow("Emission Rate", this.emissionRate);
        this.row();
        this.addLabel("Life");
        this.row();
        this.addRow("Max", this.maxLife);
        this.row();
        this.addRow("Min", this.minLife);
        this.row();
        this.addLabel("Velocity");
        this.row();
        this.addRow("Max", this.maxVelocity);
        this.row();
        this.addRow("Min", this.minVelocity);
        this.row();
        this.addLabel("Angular Velocity");
        this.row();
        this.addRow("Max", this.maxAngularVelocity);
        this.row();
        this.addRow("Min", this.minAngularVelocity);
        this.row();
        this.addLabel("Spread");
        this.row();
        this.addRow("Max", this.maxSpread);
        this.row();
        this.addRow("Min", this.minSpread);
        this.row();
        this.addLabel("Direction");
        this.row();
        this.addRow("Max", this.maxDirection);
        this.row();
        this.addRow("Min", this.minDirection);
        this.row();
        this.addLabel("Delay");
        this.row();
        this.addRow("Max", this.maxDelay);
        this.row();
        this.addRow("Min", this.minDelay);
        this.row();
        this.addLabel("Continuous");
        this.addValueCentered(this.continuous);
        this.pack();
    }

    public void applyTo(AnimatedParticleEmitter particleEmitter) {
        particleEmitter.stop();
        particleEmitter.setAnimation(new Animation<TextureAtlas.AtlasRegion>(0.1f, this.textureRegion.getSelected().getPayload()));
        particleEmitter.setEmissionRate(this.emissionRate.getValue());
        particleEmitter.setParticleAmount((int)this.particleAmount.getValue());
        particleEmitter.getLife().set(Float.valueOf(this.maxLife.getValue()), Float.valueOf(this.minLife.getValue()));
        particleEmitter.getVelocity().set(Float.valueOf(this.maxVelocity.getValue()), Float.valueOf(this.minLife.getValue()));
        particleEmitter.getDirection().set(Float.valueOf(this.maxDirection.getValue()), Float.valueOf(this.minDirection.getValue()));
        particleEmitter.getSpread().set(Float.valueOf(this.maxSpread.getValue()), Float.valueOf(this.minSpread.getValue()));
        particleEmitter.getAngularVelocity().set(Float.valueOf(this.maxAngularVelocity.getValue()), Float.valueOf(this.minVelocity.getValue()));
        particleEmitter.getDelay().set(Float.valueOf(this.maxDelay.getValue()), Float.valueOf(this.minDelay.getValue()));
        particleEmitter.setContinuous(this.continuous.isChecked());
        particleEmitter.populateWithParticles();
    }

    public void loadInto(AnimatedParticleEmitter particleEmitter) {
        String textureRegionName = particleEmitter.getSettings().regionName;
        SelectBoxWrapper selectedWrapper = null;
        for (SelectBoxWrapper selectBoxWrapper : this.textureRegion.getItems()) {
            if (!Objects.equals(selectBoxWrapper.toString(), textureRegionName)) continue;
            selectedWrapper = selectBoxWrapper;
        }
        this.textureRegion.setSelected(selectedWrapper);
        this.emissionRate.setValue(particleEmitter.getMaxEmissionRate());
        this.particleAmount.setValue(particleEmitter.getParticleAmount());
        this.maxLife.setValue(particleEmitter.getLife().getMax().floatValue());
        this.minLife.setValue(particleEmitter.getLife().getMin().floatValue());
        this.maxVelocity.setValue(particleEmitter.getLife().getMax().floatValue());
        this.minVelocity.setValue(particleEmitter.getLife().getMin().floatValue());
        this.minDirection.setValue(particleEmitter.getDirection().getMin().floatValue());
        this.maxDirection.setValue(particleEmitter.getDirection().getMax().floatValue());
        this.minSpread.setValue(particleEmitter.getSpread().getMin().floatValue());
        this.maxSpread.setValue(particleEmitter.getSpread().getMax().floatValue());
        this.minAngularVelocity.setValue(particleEmitter.getAngularVelocity().getMin().floatValue());
        this.maxAngularVelocity.setValue(particleEmitter.getAngularVelocity().getMax().floatValue());
        this.minDelay.setValue(particleEmitter.getDelay().getMin().floatValue());
        this.maxDelay.setValue(particleEmitter.getDelay().getMax().floatValue());
        this.continuous.setChecked(particleEmitter.isContinuous());
    }

    @Override
    public ValidationResult validateForm(ValidationResult result) {
        return null;
    }

    @Override
    public void resetForm() {
    }

    @Override
    public void resetValues() {
    }

    public static interface ParticleFormListener {
        public void onTextureChanged(Array<TextureAtlas.AtlasRegion> var1);
    }
}

