/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.ui.test;

import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.repository.AnimatedParticleEmitterRepository;
import com.neutronio.astrax.gfx.AnimatedParticleEmitterSettings;
import com.neutronio.astrax.gfx.factories.ParticleFactory;
import com.neutronio.astrax.gfx.particles.AnimatedParticleEmitter;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.commons.panels.SimplePanel;
import com.neutronio.astrax.ui.commons.widgets.PlayerControlWidget;
import com.neutronio.astrax.ui.test.ParticleForm;

public class ParticleSelectPanel
extends SimplePanel {
    private ParticleFactory particleFactory = AstraXApp.astraX.getFactoryByClass(ParticleFactory.class);
    private AnimatedParticleEmitterRepository particleRepository = AstraXApp.astraX.getRepository(AnimatedParticleEmitterRepository.class);
    private AnimatedParticleEmitter animatedParticleEmitter;
    private ParticleForm particleForm;
    private Container<AnimatedParticleEmitter> particleContainer;
    private TextButton applyButton;
    private PlayerControlWidget player;

    public ParticleSelectPanel(ComponentFactory componentFactory) {
        super(componentFactory);
        this.player = new PlayerControlWidget(componentFactory);
        this.applyButton = new TextButton("Apply", componentFactory.getSkin(), "primary-no-checked");
        this.particleForm = new ParticleForm(componentFactory);
        this.particleForm.setListener(new ParticleForm.ParticleFormListener(){

            @Override
            public void onTextureChanged(Array<TextureAtlas.AtlasRegion> regions) {
                ParticleSelectPanel.this.animatedParticleEmitter.setAnimation(new Animation<TextureAtlas.AtlasRegion>(0.1f, regions));
            }
        });
        this.particleForm.construct();
        this.particleForm.setPosition(20.0f, 100.0f);
        TextureAtlas atlas = AstraXApp.astraX.getCoreDataPack().getTextureAtlas();
        Array<TextureAtlas.AtlasRegion> regions = atlas.findRegions("env/particle_explosion");
        Animation<TextureAtlas.AtlasRegion> animation = new Animation<TextureAtlas.AtlasRegion>(0.1f, regions.toArray());
        animation.setPlayMode(Animation.PlayMode.NORMAL);
        this.particleContainer = new Container();
        this.animatedParticleEmitter = this.particleFactory.create(new AnimatedParticleEmitterSettings());
        this.animatedParticleEmitter.setSize(32.0f, 32.0f);
        this.particleContainer.setActor(this.animatedParticleEmitter);
        this.applyButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent changeEvent, Actor actor) {
                ParticleSelectPanel.this.particleForm.applyTo(ParticleSelectPanel.this.animatedParticleEmitter);
            }
        });
        this.player.setListener(new PlayerControlWidget.UserPlayerListener(){

            @Override
            public void onPlay() {
                ParticleSelectPanel.this.animatedParticleEmitter.start();
            }

            @Override
            public void onStop() {
                ParticleSelectPanel.this.animatedParticleEmitter.stop();
            }

            @Override
            public void onPause() {
            }

            @Override
            public void onNext() {
            }

            @Override
            public void onPrevious() {
            }
        });
        this.addValue(this.particleForm, 1);
        this.addValue(this.particleContainer, 1);
        this.row();
        this.addValue(this.applyButton, 1);
        this.addValue(this.player, 1);
        this.pack();
    }

    public void setEmitterSettings(AnimatedParticleEmitterSettings settings) {
        this.animatedParticleEmitter.remove();
        this.animatedParticleEmitter = this.particleFactory.create(settings);
        this.particleForm.loadInto(this.animatedParticleEmitter);
        this.particleContainer.setActor(this.animatedParticleEmitter);
    }
}

