/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.PixmapIO;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.neutronio.astrax.AstraXApp;
import com.neutronio.astrax.app.datapack.game.world.SatelliteTarget;
import com.neutronio.astrax.app.datapack.game.world.Targetable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.Satellite;
import com.neutronio.astrax.app.datapack.game.world.galaxy.satellite.systems.docking.DockingSystem;
import com.neutronio.astrax.gfx.AbstractGraphics;
import com.neutronio.astrax.util.MathUtil;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AstraXUtil {
    public static SimpleDateFormat screenshotDateFormat = new SimpleDateFormat("hh-mm-ss_dd-MM-yyyy");

    public static <T> List<T> mergeList(List<T> primary, List<T> list) {
        ArrayList<T> copy = new ArrayList<T>();
        for (T element : primary) {
            copy.add(element);
        }
        for (T element : list) {
            copy.add(element);
        }
        return copy;
    }

    public static <T extends Targetable> List<T> filterTargets(Collection<Targetable> list, Class<T> targetClass) {
        ArrayList<Targetable> copy = new ArrayList<Targetable>();
        for (Targetable element : list) {
            if (!targetClass.isInstance(element)) continue;
            copy.add(element);
        }
        return copy;
    }

    public static <T> List<T> copyList(List<T> list) {
        ArrayList<T> copy = new ArrayList<T>();
        for (T element : list) {
            copy.add(element);
        }
        return copy;
    }

    public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
        long diffInMillies = date2.getTime() - date1.getTime();
        return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
    }

    public static String colorToHexString(Color color) {
        return AstraXUtil.colorToString(color.r) + AstraXUtil.colorToString(color.g) + AstraXUtil.colorToString(color.b);
    }

    public static String colorToHexRGBAString(Color color) {
        return AstraXUtil.colorToString(color.r) + AstraXUtil.colorToString(color.g) + AstraXUtil.colorToString(color.b) + AstraXUtil.colorToString(color.a);
    }

    public static String colorToString(float colorValue) {
        if (colorValue == 0.0f) {
            return "00";
        }
        String hex = Integer.toHexString((int)(colorValue * 255.0f));
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static void takeScreenshot(FileHandle userDirectory) {
        Pixmap pixmap = Pixmap.createFromFrameBuffer(0, 0, Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight());
        ByteBuffer pixels = pixmap.getPixels();
        int size = Gdx.graphics.getBackBufferWidth() * Gdx.graphics.getBackBufferHeight() * 4;
        for (int i2 = 3; i2 < size; i2 += 4) {
            pixels.put(i2, (byte)-1);
        }
        FileHandle directory = userDirectory.child("/screenshots/");
        if (!directory.file().exists()) {
            directory.file().mkdir();
        }
        FileHandle fileHandle = directory.child("astrax-" + AstraXApp.VERSION + "_" + screenshotDateFormat.format(new Date()) + ".jpg");
        PixmapIO.writePNG(fileHandle, pixmap, -1, true);
        pixmap.dispose();
    }

    public static void takeScreenshot() {
        Pixmap pixmap = Pixmap.createFromFrameBuffer(0, 0, Gdx.graphics.getBackBufferWidth(), Gdx.graphics.getBackBufferHeight());
        ByteBuffer pixels = pixmap.getPixels();
        int size = Gdx.graphics.getBackBufferWidth() * Gdx.graphics.getBackBufferHeight() * 4;
        for (int i2 = 3; i2 < size; i2 += 4) {
            pixels.put(i2, (byte)-1);
        }
        String directory = "screenshots/";
        FileHandle directoryHandle = Gdx.files.local(directory);
        if (!directoryHandle.file().exists()) {
            directoryHandle.file().mkdir();
        }
        String filename = directory + "astrax-" + AstraXApp.VERSION + "_" + screenshotDateFormat.format(new Date());
        FileHandle fileHandle = Gdx.files.local(filename + ".jpg");
        PixmapIO.writePNG(fileHandle, pixmap, -1, true);
        pixmap.dispose();
    }

    public static Color[] shuffleColors(int count, Color baseColor) {
        Color[] shuffledColors = new Color[count];
        for (int i2 = 0; i2 < count; ++i2) {
            shuffledColors[i2] = new Color((baseColor.r + MathUtil.getRandomFloat(1.0f, 0.2f)) / 2.0f, (baseColor.g + MathUtil.getRandomFloat(1.0f, 0.2f)) / 2.0f, (baseColor.b + MathUtil.getRandomFloat(1.0f, 0.2f)) / 2.0f, 1.0f);
            shuffledColors[i2].clamp();
        }
        return shuffledColors;
    }

    public static Color[] shuffleColors(int count, float variance, Color baseColor) {
        Color[] shuffledColors = new Color[count];
        for (int i2 = 0; i2 < count; ++i2) {
            shuffledColors[i2] = new Color((baseColor.r + MathUtil.getRandomFloat(1.0f, 0.2f)) / 2.0f, (baseColor.g + MathUtil.getRandomFloat(variance, variance * 0.1f)) / 2.0f, (baseColor.b + MathUtil.getRandomFloat(variance, variance * 0.1f)) / 2.0f, 1.0f);
            shuffledColors[i2].clamp();
        }
        return shuffledColors;
    }

    public static Color mult(Color color, float intensity) {
        color.r *= intensity;
        color.g *= intensity;
        color.b *= intensity;
        color.clamp();
        return color;
    }

    public static boolean canDock(SatelliteTarget parent, SatelliteTarget child) {
        DockingSystem system = ((Satellite)parent.getModel()).getSystem(DockingSystem.class);
        return system.hasFreeDockingPointFor((Satellite)child.getModel());
    }

    public static void getWorldPosition(Vector2 store, Actor actor) {
        Actor current = actor;
        do {
            store.x += current.getX();
            store.y += current.getY();
        } while ((current = current.getParent()) != null);
    }

    public static List<AbstractGraphics> actorToGraphicsList(List<Actor> graphics) {
        ArrayList<AbstractGraphics> result = new ArrayList<AbstractGraphics>();
        for (Actor actor : graphics) {
            if (!(actor instanceof AbstractGraphics)) continue;
            result.add((AbstractGraphics)actor);
        }
        return result;
    }
}

