/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;

public enum ColorBlend {
    NORMAL{

        @Override
        public Color mix(Color primary, Color secondary, float alpha) {
            return primary;
        }
    }
    ,
    SCREEN{

        @Override
        public Color mix(Color primary, Color secondary, float alpha) {
            return new Color(MathUtils.clamp(1.0f - (1.0f - primary.r) * (1.0f - secondary.r), 0.0f, 1.0f), MathUtils.clamp(1.0f - (1.0f - primary.g) * (1.0f - secondary.g), 0.0f, 1.0f), MathUtils.clamp(1.0f - (1.0f - primary.b) * (1.0f - secondary.b), 0.0f, 1.0f), MathUtils.clamp(1.0f - (1.0f - primary.a) * (1.0f - secondary.a), 0.0f, 1.0f));
        }
    }
    ,
    INTERPOLATE{

        @Override
        public Color mix(Color primary, Color secondary, float alpha) {
            return new Color(MathUtils.clamp(primary.r * alpha + secondary.r * (1.0f - alpha), 0.0f, 1.0f), MathUtils.clamp(primary.g * alpha + secondary.g * (1.0f - alpha), 0.0f, 1.0f), MathUtils.clamp(primary.b * alpha + secondary.b * (1.0f - alpha), 0.0f, 1.0f), MathUtils.clamp(primary.a * alpha + secondary.a * (1.0f - alpha), 0.0f, 1.0f));
        }
    };


    public abstract Color mix(Color var1, Color var2, float var3);
}

