/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util;

import com.neutronio.astrax.AstraXException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;

public class Counter<T> {
    private static final Logger logger = Logger.getLogger(Counter.class.getCanonicalName());
    private boolean allowNull = false;
    private int totalCounts = 0;
    private Map<T, Integer> counterMap = new LinkedHashMap<T, Integer>();
    private Map<T, String> displayKey;

    public Counter(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public Counter() {
    }

    public void addDisplayName(T forKey, String displayName) {
        if (this.displayKey == null) {
            this.displayKey = new LinkedHashMap<T, String>();
        }
        this.displayKey.put(forKey, displayName);
    }

    public void addOne(T object) {
        this.addMany(object, 1);
    }

    public void addMany(T object, int count) {
        if (!this.allowNull && object == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Null values not allowed");
        }
        if (this.counterMap.containsKey(object)) {
            this.totalCounts += count;
            this.counterMap.put(object, this.counterMap.get(object) + count);
        } else {
            this.totalCounts += count;
            this.counterMap.put(object, count);
        }
    }

    public void subtractOne(T object) {
        this.subtractMany(object, 1);
    }

    public void subtractMany(T object, int count) {
        if (!this.allowNull && object == null) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Null values not allowed");
        }
        if (this.counterMap.containsKey(object)) {
            this.totalCounts -= count;
            this.counterMap.put(object, this.counterMap.get(object) - count);
        } else {
            this.totalCounts -= count;
            this.counterMap.put(object, -count);
        }
    }

    public Integer get(T object) {
        if (this.counterMap.containsKey(object)) {
            return this.counterMap.get(object);
        }
        return 0;
    }

    public boolean containsKey(T object) {
        return this.counterMap.containsKey(object);
    }

    public boolean isAllowNull() {
        return this.allowNull;
    }

    public void setAllowNull(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public float getPercent(T object) {
        if (this.totalCounts == 0 || this.counterMap.get(object) == 0) {
            return 0.0f;
        }
        return (float)this.counterMap.get(object).intValue() / (float)this.totalCounts * 100.0f;
    }

    public int getTotalCounts() {
        return this.totalCounts;
    }

    public void reset() {
        this.totalCounts = 0;
        for (T key : this.counterMap.keySet()) {
            this.counterMap.put(key, 0);
        }
    }

    public Map<T, Integer> getCounterMap() {
        HashMap<T, Integer> copy = new HashMap<T, Integer>();
        for (Map.Entry<T, Integer> entries : this.counterMap.entrySet()) {
            copy.put(entries.getKey(), entries.getValue());
        }
        return copy;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n================================\n");
        builder.append("TOTAL COUNT: ").append(this.totalCounts);
        builder.append("\n================================\n");
        for (Map.Entry<T, Integer> entry : this.counterMap.entrySet()) {
            Integer value = entry.getValue();
            builder.append(this.displayKey == null ? entry.getKey() : this.displayKey.get(entry.getKey())).append(":\t").append(value).append(" (").append(this.getPercent(entry.getKey())).append(" % )\n");
        }
        builder.append("================================\n");
        return builder.toString();
    }
}

