/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util;

import com.badlogic.gdx.graphics.Color;
import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.util.AstraXUtil;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONUtils {
    public static <T extends Enum> T toEnum(Class<T> enumType, Object mapObject) {
        T foundEnum = null;
        if (mapObject instanceof String) {
            foundEnum = Enum.valueOf(enumType, (String)mapObject);
        }
        return foundEnum;
    }

    public static Integer[] toIntegerArray(List<Integer> list) {
        Integer[] integers = new Integer[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            integers[i2] = list.get(i2);
        }
        return integers;
    }

    public static JSONObject toJSONObject(Map<String, Color> colorPalette) {
        JSONObject colorJson = new JSONObject();
        for (Map.Entry<String, Color> colorEntry : colorPalette.entrySet()) {
            colorJson.put(colorEntry.getKey(), AstraXUtil.colorToHexRGBAString(colorEntry.getValue()));
        }
        return colorJson;
    }

    public static Map<String, Color> toColorPalette(Object mapObject) {
        if (mapObject instanceof JSONObject) {
            LinkedHashMap<String, Color> palette = new LinkedHashMap<String, Color>();
            JSONObject colors = (JSONObject)mapObject;
            for (String key : colors.keySet()) {
                palette.put(key.toString(), Color.valueOf((String)colors.get(key)));
            }
            return palette;
        }
        if (mapObject instanceof Map) {
            LinkedHashMap<String, Color> palette = new LinkedHashMap<String, Color>();
            Map colors = (Map)mapObject;
            for (Object key : colors.keySet()) {
                palette.put(key.toString(), Color.valueOf((String)colors.get(key)));
            }
            return palette;
        }
        throw new AstraXException(AstraXException.ErrorCode.E0004, "Object must be an instance of JSONObject! Did you get the right JSON value?");
    }

    public static JSONArray toJSONArray(Integer[] integers) {
        JSONArray array = new JSONArray();
        for (Integer i2 : integers) {
            array.put(i2);
        }
        return array;
    }

    public static float toFloat(Object mapObject) {
        if (mapObject instanceof Number) {
            return ((Number)mapObject).floatValue();
        }
        throw new AstraXException(AstraXException.ErrorCode.E0004, "Object must be an instance of Number! Did you get the right JSON value?");
    }

    public static int toInteger(Object mapObject) {
        if (mapObject instanceof Number) {
            return ((Number)mapObject).intValue();
        }
        throw new AstraXException(AstraXException.ErrorCode.E0004, "Object must be an instance of Number! Did you get the right JSON value?");
    }

    public static long toLong(Object mapObject) {
        if (mapObject instanceof Number) {
            return ((Number)mapObject).longValue();
        }
        throw new AstraXException(AstraXException.ErrorCode.E0004, "Object must be an instance of Number! Did you get the right JSON value?");
    }

    public static Color toColor(Object mapObject) {
        if (mapObject instanceof Map) {
            Map colorMap = (Map)mapObject;
            if (colorMap.containsKey("hex")) {
                String hex = (String)colorMap.get("hex");
                return Color.valueOf(hex);
            }
            float r = JSONUtils.toFloat(colorMap.get("r"));
            float g = JSONUtils.toFloat(colorMap.get("g"));
            float b = JSONUtils.toFloat(colorMap.get("b"));
            float a = JSONUtils.toFloat(colorMap.get("a"));
            return new Color(r, g, b, a);
        }
        throw new AstraXException(AstraXException.ErrorCode.E0004, "Object must be an instance of Number! Did you get the right JSON value?");
    }

    public static List<String> toStringList(Object mapObject) {
        if (mapObject instanceof List) {
            return (List)mapObject;
        }
        throw new AstraXException(AstraXException.ErrorCode.E0004, "Object must be a list of Strings! Did you get the right JSON value?");
    }
}

