/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.neutronio.astrax.util.Ranged;
import java.util.Random;

public class MathUtil {
    static Random random = new Random();

    public static float getAsteroidCountByDensity(float density, float maxradius, float minradius) {
        density = MathUtils.clamp(density, 0.0f, 1.0f);
        float area = MathUtil.getDiscArea(maxradius, minradius);
        return density * (area / 10000.0f * density);
    }

    public static float getDiscArea(float maxradius, float minradius) {
        float maxVol = (float)(Math.PI * Math.pow(maxradius, 2.0));
        float minVol = (float)(Math.PI * Math.pow(minradius, 2.0));
        return maxVol - minVol;
    }

    public static float getAngleBetweenVectors(Vector2 primaryPos, Vector2 secondaryPos) {
        Vector2 t1 = primaryPos.sub(secondaryPos);
        return t1.angleDeg();
    }

    public static float getAngleBetweenVectors(Vector2 primaryPos, float x, float y) {
        Vector2 t1 = primaryPos.sub(x, y);
        return t1.angleDeg();
    }

    public static float vectorsToAngle(float x1, float y1, float x2, float y2) {
        float delta_x = Math.abs(x1 - x2);
        float delta_y = Math.abs(y1 - y2);
        return (float)Math.atan2(delta_y, delta_x);
    }

    public static float vectorsToAngle(Vector2 v1, Vector2 v2) {
        float delta_x = Math.abs(v1.x - v2.x);
        float delta_y = Math.abs(v1.y - v2.y);
        return (float)Math.atan2(delta_y, delta_x);
    }

    public static Color hexToColor(String hex) {
        String hexColor = hex.replace('#', ' ');
        hexColor = hexColor.trim();
        return Color.valueOf(hexColor);
    }

    public static String colorToHex(Color color) {
        return "#" + color.toString();
    }

    public static Vector2 getDirectionalVector(float length, float radians) {
        double scalex = Math.cos(radians);
        double scaley = Math.sin(radians);
        double velox = (double)length * scalex;
        double veloy = (double)length * scaley;
        return new Vector2((float)velox, (float)veloy);
    }

    public static float getAngle(Vector2 direction) {
        return (float)Math.atan2(direction.y, direction.x);
    }

    public static Vector2 rotate(Vector2 toRotate, Vector2 origin, float angle) {
        float x = (float)((double)(toRotate.x - origin.x) * Math.cos(angle) - (double)(toRotate.y - origin.y) * Math.sin(angle) + (double)origin.x);
        float y = (float)((double)(origin.y - toRotate.y) * Math.cos(angle) - (double)(toRotate.x - origin.x) * Math.sin(angle) + (double)origin.y);
        return new Vector2(x, y);
    }

    public static Vector2 rotate(Vector2 v, double radians) {
        Vector2 result = new Vector2();
        float x = (float)((double)v.x * Math.cos(radians) - (double)v.y * Math.sin(radians));
        float y = (float)((double)v.x * Math.sin(radians) + (double)v.y * Math.cos(radians));
        result.x = x;
        result.y = y;
        return result;
    }

    public static float getRandomFloat(float max, float min) {
        if (max < min) {
            throw new IllegalArgumentException("Min can't be larger than max!");
        }
        return random.nextFloat() * (max - min) + min;
    }

    public static int getRandomInteger(int bound) {
        return random.nextInt(bound);
    }

    public static <T extends Number> T getRandom(Ranged<T> rangedValue) {
        if (rangedValue.getMax() instanceof Double) {
            return (T)Double.valueOf(random.nextDouble() * ((Double)rangedValue.getMax() - (Double)rangedValue.getMin()) + (Double)rangedValue.getMin());
        }
        if (rangedValue.getMax() instanceof Float) {
            return (T)Float.valueOf(random.nextFloat() * (((Float)rangedValue.getMax()).floatValue() - ((Float)rangedValue.getMin()).floatValue()) + ((Float)rangedValue.getMin()).floatValue());
        }
        if (rangedValue.getMax() instanceof Integer) {
            return (T)Integer.valueOf(random.nextInt() * ((Integer)rangedValue.getMax() - (Integer)rangedValue.getMin()) + (Integer)rangedValue.getMin());
        }
        if (rangedValue.getMax() instanceof Long) {
            return (T)Long.valueOf(random.nextLong() * ((Long)rangedValue.getMax() - (Long)rangedValue.getMin()) + (Long)rangedValue.getMin());
        }
        return (T)Integer.valueOf(0);
    }
}

