/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util;

import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.AstraXException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Modifiers {
    private float min = 0.0f;
    private float max = 1.0f;
    private Map<String, Float> modifiers = new HashMap<String, Float>();

    public Modifiers() {
    }

    public Modifiers(float max, float min) {
        this.setRange(max, min);
    }

    public void putModifier(String key, float value) {
        float clamped = Math.min(Math.max(this.min, value), this.max);
        this.modifiers.put(key, Float.valueOf(clamped));
    }

    public Float get(String key) {
        if (!this.modifiers.containsKey(key)) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(MathUtils.clamp(this.modifiers.get(key).floatValue(), this.min, this.max));
    }

    public boolean containsKey(String key) {
        return this.modifiers.containsKey(key);
    }

    public void setRange(float max, float min) {
        if (!(max > min)) {
            throw new AstraXException(AstraXException.ErrorCode.E0004, "Min can't be larger than Max!");
        }
        this.max = max;
        this.min = min;
    }

    public void addToModifier(String key, float value) {
        Float modifier = this.modifiers.get(key);
        if (modifier != null) {
            this.modifiers.put(key, Float.valueOf((float)Math.round((modifier.floatValue() + value) * 100.0f) / 100.0f));
        } else {
            this.putModifier(key, value);
        }
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public void reset() {
        this.modifiers.clear();
    }

    public int size() {
        return this.modifiers.size();
    }

    public Set<Map.Entry<String, Float>> getEntries() {
        return this.modifiers.entrySet();
    }

    public String toString() {
        return "Modifiers{modifiers=" + this.modifiers + '}';
    }
}

