/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util;

import com.neutronio.astrax.app.datapack.NameRandomizerSettings;
import com.neutronio.astrax.util.Counter;
import com.neutronio.astrax.util.sequences.NumberGenerator;
import com.neutronio.astrax.util.sequences.RomanNumeralConverter;
import java.util.ArrayList;
import java.util.Arrays;

public class NameRandomizer {
    private NameRandomizerSettings settings = new NameRandomizerSettings();
    private NumberGenerator numberGenerator;
    private Counter<String> nameCounter = new Counter();
    private RomanNumeralConverter romanNumeralConverter = new RomanNumeralConverter();

    public NumberGenerator getNumberGenerator() {
        return this.numberGenerator;
    }

    public void setNumberGenerator(NumberGenerator numberGenerator) {
        this.numberGenerator = numberGenerator;
    }

    public boolean isUseSpacing() {
        return this.settings.isUseSpacing();
    }

    public void setUseSpacing(boolean useSpacing) {
        this.settings.setUseSpacing(useSpacing);
    }

    public NameRandomizerSettings getSettings() {
        return this.settings;
    }

    public void setSettings(NameRandomizerSettings settings) {
        if (settings == null) {
            throw new NullPointerException("NameRandomizerSettings cannot be null");
        }
        this.settings = settings;
    }

    public String generateName() {
        String name = this.combineName();
        this.nameCounter.addOne(name);
        return name + " " + this.romanNumeralConverter.toRoman(this.nameCounter.get(name));
    }

    private String combineName() {
        String part1 = this.numberGenerator.getRandomEntry(this.settings.getFirstSet());
        String part2 = this.numberGenerator.getRandomEntry(this.settings.getSecondSet());
        return part1 + (this.settings.isUseSpacing() && !part2.isEmpty() ? " " : "") + (part2.isEmpty() ? "" : part2);
    }

    private void getRomanNumeral() {
    }

    public static void main(String[] args) {
        NameRandomizer.galaxyNames();
        System.out.println("_________");
        NameRandomizer.starNames();
        System.out.println("_________");
        NameRandomizer.fantasyNames();
        System.out.println("_________");
        NameRandomizer.doubleJoinedFantasyNames();
    }

    public static void doubleJoinedFantasyNames() {
        NameRandomizer randomizer = new NameRandomizer();
        randomizer.setUseSpacing(false);
        randomizer.getSettings().setFirstSet(Arrays.asList("Arman", "An", "Ala", "Ath", "Ari", "Bor", "Buho", "Bium", "Bim", "Canda", "Cor", "Cepro", "Can", "Cron", "Dan", "Danca", "Don", "Di", "Delem", "Den", "Espa", "Era", "En", "Lyde", "Lup", "Lan", "Is", "Ir", "In", "Illi", "Hy", "Hyph", "Hispa", "Her", "Phi", "Peg", "Pri", "Phe", "Mac", "Mor", "Mat", "Mete", "Mega", "Tau", "Tan", "Tu", "The", "Tha", "Thamega", "Ur", "Gob", "Piscu", "Od", "Oln", "Osmos", "Orsa", "Scor", "Spar", "Ser", "Sus", "Spa", "Vega", "Veng", "Vultu", "Vul"));
        randomizer.getSettings().setSecondSet(Arrays.asList("vus", "os", "or", "um", "na", "us", "k", "un", "is", "am", "er", "da", "du", "eman", "ros", "dor", "leum", "an", "shan", "ium"));
        ArrayList<String> fantasyNames = new ArrayList<String>();
        for (int i2 = 0; i2 < 100; ++i2) {
            fantasyNames.add(randomizer.generateName());
        }
        NameRandomizer randomizerLevel1 = new NameRandomizer();
        randomizerLevel1.setUseSpacing(true);
        randomizerLevel1.getSettings().setFirstSet(Arrays.asList("Alpha", "Beta", "Gamma", "Delta", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Omicron", "Rho", "Sigma", "Tau", "Epsilon", "Omega"));
        randomizerLevel1.getSettings().setSecondSet(fantasyNames);
        for (int i3 = 0; i3 < 200; ++i3) {
            System.out.println(randomizerLevel1.generateName());
        }
    }

    public static void fantasyNames() {
        NameRandomizer randomizer = new NameRandomizer();
        randomizer.setUseSpacing(false);
        randomizer.getSettings().setFirstSet(Arrays.asList("Canda", "Tau", "Ur", "Gob", "Peg", "Ala", "Os", "Orsa", "Arman", "Vultu", "Vin", "Vul", "Lym", "Lyde", "Piscu", "Her", "Cor", "Scor", "Dan", "Dancat", "Den", "Jun", "Ceph", "Cepro", "Hy", "Hyph", "Hispan", "Serb", "Lup", "Osmos", "Sol", "Tud", "Pun"));
        randomizer.getSettings().setSecondSet(Arrays.asList("or", "um", "na", "us", "k", "un", "is", "am", "er", "a", "u", "man", "entu", "leum", "an", "din"));
        for (int i2 = 0; i2 < 100; ++i2) {
            System.out.println(randomizer.generateName());
        }
    }

    public static void galaxyNames() {
        NameRandomizer randomizer = new NameRandomizer();
        randomizer.setUseSpacing(true);
        randomizer.getSettings().setFirstSet(Arrays.asList("Canis", "Taurus", "Ursa", "Pegasus", "Orion", "Pegasus", "Aries", "Vulpus", "Lyra", "Pisces", "Hercules", "Corvus", "Scorpius", "Draco", "Cepheus", "Hydra", "Serpens", "Lupus", "Corona", "Vela", "Cygnus", "Lacerta", "Fenestra", "Ferrum", "Iridium", "Cuprum", "Carina", "Grus", "Spatula", "Polis", "Musica", "Mergana", "Libertad", "Usted", "Angus"));
        randomizer.getSettings().setSecondSet(Arrays.asList("", "", "Major", "Minor", "Primus", "Secundus", "Tertius", "Borealis", "Galacticus"));
        for (int i2 = 0; i2 < 100; ++i2) {
            System.out.println(randomizer.generateName());
        }
    }

    public static void starNames() {
        NameRandomizer randomizer = new NameRandomizer();
        randomizer.setUseSpacing(true);
        randomizer.getSettings().setFirstSet(Arrays.asList("Alpha", "Beta", "Gamma", "Delta", "Zeta", "Eta", "Theta", "Iota", "Kappa", "Lambda", "Omicron", "Rho", "Sigma", "Tau", "Epsilon", "Omega"));
        randomizer.getSettings().setSecondSet(Arrays.asList("Pollux", "Centaur", "Ursa", "Eridanus", "Cassiopeia", "Capella", "Castor", "Orion", "Atlas", "Deneb", "Diadem", "Copernicus", "Fafnir", "Ishtar", "Argentium"));
        for (int i2 = 0; i2 < 100; ++i2) {
            System.out.println(randomizer.generateName());
        }
    }
}

