/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util;

import java.util.ArrayList;
import java.util.List;

public class Tree<T> {
    private Node root = new Node<Object>(null);

    public Node<T> getRoot() {
        return this.root;
    }

    public Node<T> add(Node<T> node) {
        return this.root.addChild(node);
    }

    public Node<T> remove(Node<T> node) {
        return this.root.removeChild(node);
    }

    public int childrenCount() {
        return this.root.size();
    }

    public Node<T> getChildAt(int index) {
        return this.root.getChild(index);
    }

    private void getStringRecursive(int currentDepth, Node<T> current, StringBuilder builder) {
        if (current != null) {
            builder.append("\n");
            for (int i2 = 0; i2 < currentDepth; ++i2) {
                builder.append("- ");
            }
            builder.append(current.object);
            for (Node node : current.children) {
                this.getStringRecursive(currentDepth + 1, node, builder);
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.getStringRecursive(0, this.root, builder);
        return builder.toString();
    }

    public static class Node<T> {
        private Node<T> parent = null;
        protected List<Node<T>> children = new ArrayList<Node<T>>();
        protected T object;

        public Node(T object) {
            this.object = object;
        }

        public Node<T> addChild(Node<T> child) {
            child.parent = this;
            this.children.add(child);
            return child;
        }

        public T getObject() {
            return this.object;
        }

        public void setObject(T object) {
            this.object = object;
        }

        public Node<T> remove() {
            return this.parent.removeChild(this);
        }

        public Node<T> removeChild(int index) {
            Node<T> remove = this.children.remove(index);
            remove.parent = null;
            return remove;
        }

        public boolean containsChild(Node<T> node) {
            return this.children.contains(node);
        }

        public Node<T> getChild(int index) {
            return this.children.get(index);
        }

        public Node<T> removeChild(Node<T> node) {
            this.children.remove(node);
            node.parent = null;
            return node;
        }

        public int size() {
            return this.children.size();
        }

        public Node<T> getParent() {
            return this.parent;
        }
    }
}

