/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.animation;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.neutronio.astrax.ui.commons.action.CustomAction;

public class Tweening {
    public static Action getGrowlAnimation(float shopDuration) {
        return Actions.sequence(Actions.show(), Actions.touchable(Touchable.enabled), Actions.alpha(1.0f, 0.1f), Tweening.getRumbleX(0.1f, 6.0f), Actions.delay(shopDuration), Actions.alpha(0.0f, 1.0f), Actions.touchable(Touchable.disabled), Actions.hide());
    }

    public static Action getSystemDetachAnimation() {
        return Actions.sequence((Action)Actions.fadeOut(2.0f), (Action)Actions.removeActor());
    }

    public static Action getSystemAttachAnimation() {
        return Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.visible(true), (Action)Actions.fadeIn(2.0f));
    }

    public static Action getScaleRumble() {
        return Actions.repeat(2, Actions.sequence((Action)Actions.scaleBy(0.5f, 0.5f, 0.1f), (Action)Actions.scaleBy(-0.5f, -0.5f, 0.1f)));
    }

    public static Action getScaleRumble(float amount) {
        return Actions.repeat(2, Actions.sequence((Action)Actions.scaleBy(amount, amount, 0.1f), (Action)Actions.scaleBy(-amount, -amount, 0.1f)));
    }

    public static Action getSquish(float strength, CustomAction customAction) {
        strength = MathUtils.clamp(strength, 0.0f, 1.0f);
        if (customAction != null) {
            return Actions.sequence(Actions.scaleBy(-0.1f, -0.1f, 0.05f, Interpolation.smooth), Actions.scaleBy(0.2f * strength, -0.1f, 0.07f, Interpolation.smooth), Actions.scaleTo(1.0f, 1.0f, 0.1f, Interpolation.smooth), Actions.scaleBy(-0.1f, -0.1f, 0.05f, Interpolation.smooth), Actions.scaleBy(0.1f, 0.1f, 0.05f, Interpolation.smooth), customAction);
        }
        return Actions.sequence((Action)Actions.scaleBy(-0.1f, -0.1f, 0.05f, Interpolation.smooth), (Action)Actions.scaleBy(0.2f * strength, -0.1f, 0.07f, Interpolation.smooth), (Action)Actions.scaleTo(1.0f, 1.0f, 0.1f, Interpolation.smooth), (Action)Actions.scaleBy(-0.1f, -0.1f, 0.05f, Interpolation.smooth), (Action)Actions.scaleBy(0.1f, 0.1f, 0.05f, Interpolation.smooth));
    }

    public static Action getSquish(float strength) {
        strength = MathUtils.clamp(strength, 0.0f, 2.0f);
        return Actions.sequence((Action)Actions.scaleBy(-0.1f, -0.1f, 0.05f, Interpolation.smooth), (Action)Actions.scaleBy(0.2f * strength, -0.1f, 0.07f, Interpolation.smooth), (Action)Actions.scaleTo(1.0f, 1.0f, 0.1f, Interpolation.smooth), (Action)Actions.scaleBy(-0.1f, -0.1f, 0.05f, Interpolation.smooth), (Action)Actions.scaleBy(0.1f, 0.1f, 0.05f, Interpolation.smooth));
    }

    public static Action getSlowInfiniteBounce() {
        return Actions.forever(Actions.sequence((Action)Actions.moveBy(0.0f, -20.0f, 0.8f), (Action)Actions.moveBy(0.0f, 20.0f, 0.2f)));
    }

    public static Action getInfiniteScaleBounce() {
        return Actions.forever(Actions.sequence((Action)Actions.scaleBy(0.5f, 0.5f, 0.8f), (Action)Actions.scaleBy(-0.5f, -0.5f, 0.2f)));
    }

    public static Action getScaleBounce(int times, float scaleExtent, float duration) {
        return Actions.repeat(times, Actions.sequence((Action)Actions.scaleBy(scaleExtent, scaleExtent, 0.8f * duration, Interpolation.pow2), (Action)Actions.scaleBy(-scaleExtent, -scaleExtent, 0.2f * duration)));
    }

    public static Action getRumbleY(float duration) {
        return Actions.repeat(2, Actions.sequence((Action)Actions.moveBy(0.0f, 6.0f, duration), (Action)Actions.moveBy(0.0f, -12.0f, duration), (Action)Actions.moveBy(0.0f, 6.0f, duration)));
    }

    public static Action getRumbleX(float duration, float pixels) {
        return Actions.repeat(2, Actions.sequence((Action)Actions.moveBy(pixels, 0.0f, duration), (Action)Actions.moveBy(-pixels * 2.0f, 0.0f, duration), (Action)Actions.moveBy(pixels, 0.0f, duration)));
    }

    public static Action getAsteroidCrackRumbleXY(float startPosX, float startPosY) {
        return Actions.sequence((Action)Actions.moveBy(MathUtils.random(-1.0f, 1.0f) * 4.0f, MathUtils.random(-1.0f, 1.0f) * 4.0f, 0.05f), (Action)Actions.moveBy(MathUtils.random(-1.0f, 1.0f) * 3.0f, MathUtils.random(-1.0f, 1.0f) * 3.0f, 0.05f), (Action)Actions.moveBy(MathUtils.random(-1.0f, 1.0f) * 2.0f, MathUtils.random(-1.0f, 1.0f) * 2.0f, 0.05f), (Action)Actions.moveBy(MathUtils.random(-1.0f, 1.0f), MathUtils.random(-1.0f, 1.0f), 0.05f), (Action)Actions.moveTo(startPosX, startPosY, 0.1f));
    }

    public static Action getDropDownFadeOut(float duration) {
        return Actions.sequence((Action)Actions.parallel((Action)Actions.fadeOut(duration), (Action)Actions.touchable(Touchable.disabled)), (Action)Actions.hide(), (Action)Actions.alpha(0.0f));
    }

    public static Action getDropDownFadeIn(float duration) {
        return Actions.sequence((Action)Actions.moveBy(0.0f, 100.0f), (Action)Actions.alpha(0.0f), (Action)Actions.show(), (Action)Actions.parallel((Action)Actions.moveBy(0.0f, -100.0f, duration, Interpolation.pow2), (Action)Actions.touchable(Touchable.enabled), (Action)Actions.fadeIn(duration)));
    }

    public static Action getSlideFadeOut(float duration, float moveToX, float moveToY) {
        return Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.show(), (Action)Actions.parallel((Action)Actions.moveTo(moveToX, moveToY, duration, Interpolation.pow2), (Action)Actions.fadeOut(duration), (Action)Actions.touchable(Touchable.disabled)), (Action)Actions.hide());
    }

    public static Action getSlideFadeIn(float duration, float moveToX, float moveToY) {
        return Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.show(), (Action)Actions.parallel((Action)Actions.moveTo(moveToX, moveToY, duration), (Action)Actions.fadeIn(duration), (Action)Actions.touchable(Touchable.enabled)));
    }

    public static Action getSlideFadeOutWithAction(float duration, float moveToX, float moveToY, CustomAction customAction) {
        return Actions.sequence(Tweening.getSlideFadeOut(duration, moveToX, moveToY), (Action)customAction);
    }

    public static Action getSlideFadeInWithAction(float duration, float moveToX, float moveToY, CustomAction customAction) {
        return Actions.sequence(Tweening.getSlideFadeIn(duration, moveToX, moveToY), (Action)customAction);
    }

    public static Action getDefaultFadeOut(float duration) {
        return Actions.sequence((Action)Actions.parallel(Tweening.getRumbleY(0.1f), (Action)Actions.fadeOut(duration)), (Action)Actions.hide(), (Action)Actions.touchable(Touchable.disabled));
    }

    public static Action getDefaultFadeIn(float duration) {
        return Actions.sequence((Action)Actions.touchable(Touchable.enabled), (Action)Actions.show(), (Action)Actions.parallel(Tweening.getRumbleY(0.1f), (Action)Actions.fadeIn(duration)));
    }

    public static Action getCenteredFadeIn() {
        return Actions.sequence(Actions.moveToAligned((float)Gdx.graphics.getWidth() / 2.0f, Gdx.graphics.getHeight(), 1), Actions.visible(true), Actions.parallel((Action)Actions.fadeIn(0.2f), (Action)Actions.moveToAligned((float)Gdx.graphics.getWidth() / 2.0f, (float)Gdx.graphics.getHeight() / 2.0f, 1, 0.5f, Interpolation.swing)), Actions.moveBy(-6.0f, 0.0f, 0.05f), Actions.moveBy(6.0f, 0.0f, 0.05f), Actions.moveBy(-6.0f, 0.0f, 0.05f), Actions.moveBy(6.0f, 0.0f, 0.05f), Actions.moveBy(-3.0f, 0.0f, 0.05f));
    }

    public static Action getCenteredFadeOut() {
        return Actions.sequence((Action)Actions.parallel((Action)Actions.fadeOut(0.4f), (Action)Actions.moveToAligned((float)Gdx.graphics.getWidth() / 2.0f, -Gdx.graphics.getHeight(), 1, 0.8f, Interpolation.swing)), (Action)Actions.visible(false));
    }

    public static Action getStackControllerFadeOut() {
        return Actions.sequence((Action)Actions.parallel((Action)Actions.moveTo(-Gdx.graphics.getWidth(), 0.0f, 0.4f, Interpolation.pow2), (Action)Actions.fadeOut(0.1f)), (Action)Actions.visible(false));
    }

    public static Action getStackControllerFadeIn() {
        return Actions.sequence((Action)Actions.visible(true), (Action)Actions.parallel((Action)Actions.fadeIn(0.1f), (Action)Actions.moveTo(0.0f, 0.0f, 0.4f, Interpolation.pow2)));
    }
}

