/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.collections;

import com.badlogic.gdx.math.MathUtils;
import com.neutronio.astrax.util.collections.Selector;
import java.util.List;

public class DefaultSelector<T>
implements Selector<T> {
    private int selectedIndex = -1;
    private List<T> elements;

    @Override
    public T getSelected() {
        return this.selectedIndex >= 0 ? (T)this.elements.get(this.selectedIndex) : null;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public void select(T selected) {
        this.selectedIndex = this.elements.indexOf(selected);
    }

    @Override
    public void select(int index) {
        this.selectedIndex = MathUtils.clamp(index, 0, this.elements.size());
    }

    @Override
    public void deselect() {
        this.selectedIndex = -1;
    }

    @Override
    public void previousElement() {
        if (this.elements.size() == 0) {
            return;
        }
        --this.selectedIndex;
        if (this.selectedIndex < 0) {
            this.selectedIndex = this.elements.size() - 1;
        }
    }

    @Override
    public void nextElement() {
        if (this.elements.size() == 0) {
            return;
        }
        this.selectedIndex = (this.selectedIndex + 1) % this.elements.size();
    }

    @Override
    public List<T> getElements() {
        return this.elements;
    }

    @Override
    public void setElements(List<T> elements) {
        this.elements = elements;
    }
}

