/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.collections;

import java.io.Serializable;

public class Grid<C>
implements Serializable {
    private static final long serialVersionUID = 453540746598647840L;
    private int width;
    private int height;
    private Object[][] cells;

    public Grid(int width, int height) {
        this.width = width;
        this.height = height;
        this.cells = new Object[width][height];
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void place(int x, int y, C object) {
        if (this.isInBounds(x, y)) {
            this.cells[x][y] = object;
        }
    }

    public C get(int x, int y) {
        if (this.isInBounds(x, y)) {
            return (C)this.cells[x][y];
        }
        return null;
    }

    public boolean erase(int x, int y) {
        if (this.isInBounds(x, y)) {
            this.cells[x][y] = null;
            return true;
        }
        return false;
    }

    public boolean isInBounds(int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        return x < this.cells.length && y < this.cells[x].length;
    }

    public boolean isEmpty(int x, int y) {
        if (this.isInBounds(x, y)) {
            return this.cells[x][y] == null;
        }
        return true;
    }

    public void clear() {
        for (int x = 0; x < this.cells.length; ++x) {
            for (int y = 0; y < this.cells[x].length; ++y) {
                this.cells[x][y] = null;
            }
        }
    }
}

