/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupedMap<K, E> {
    protected Map<String, GroupContainer<E>> data = new HashMap<String, GroupContainer<E>>(10);

    public Set<String> getGroupKeys() {
        return this.data.keySet();
    }

    public int sizeOfGroup(String key) {
        if (this.data.containsKey(key)) {
            return this.data.get(key).size();
        }
        return -1;
    }

    public void remove(String key, E element) {
        if (this.data.containsKey(key)) {
            return;
        }
        this.data.get(key).remove(element);
    }

    public int size() {
        return this.data.size();
    }

    public E getElement(String key, int index) {
        if (this.data.containsKey(key)) {
            return this.data.get(key).get(index);
        }
        return null;
    }

    public List<E> getElements(String key) {
        if (this.data.containsKey(key)) {
            return this.data.get((Object)key).elements;
        }
        return null;
    }

    public void addToGroup(String key, E element) {
        if (element == null) {
            return;
        }
        GroupContainer<E> group = null;
        if (this.data.containsKey(key)) {
            group = this.data.get(key);
        } else {
            group = new GroupContainer<E>();
            this.data.put(key, group);
        }
        group.add(element);
    }

    public void addAllToGroup(String key, Collection<E> elements) {
        if (elements == null || elements.isEmpty()) {
            return;
        }
        GroupContainer<E> group = null;
        if (this.data.containsKey(key)) {
            group = this.data.get(key);
        } else {
            group = new GroupContainer<E>();
            this.data.put(key, group);
        }
        group.addAll(elements);
    }

    public static class GroupContainer<E> {
        List<E> elements = new ArrayList();

        public void remove(E element) {
            if (!this.elements.contains(element)) {
                return;
            }
            this.elements.remove(element);
        }

        public void add(E element) {
            if (this.elements.contains(element)) {
                return;
            }
            this.elements.add(element);
        }

        public void addAll(Collection<E> elements) {
            for (E element : elements) {
                if (this.elements.contains(element)) continue;
                this.elements.add(element);
            }
        }

        public E get(int index) {
            return this.elements.get(index);
        }

        public int size() {
            return this.elements.size();
        }
    }
}

