/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.collections;

import com.neutronio.astrax.AstraXException;
import com.neutronio.astrax.util.collections.Grid;
import java.util.LinkedHashMap;
import java.util.Map;

public class IndexedGrid<T> {
    private short currentID = Short.MIN_VALUE;
    private Grid<Short> data;
    private Map<Short, T> objectIndex = new LinkedHashMap<Short, T>();

    public IndexedGrid(int width, int heigth) {
        this.data = new Grid(width, heigth);
    }

    public Short getNewID() {
        this.currentID = (short)(this.currentID + 1);
        return this.currentID;
    }

    public void put(T object, Short id, int x, int y) {
        this.data.place(x, y, id);
        if (!this.objectIndex.containsKey(id)) {
            this.objectIndex.put(id, object);
        }
    }

    public void putTile(Short id, int x, int y) {
        if (!this.objectIndex.containsKey(id)) {
            throw new AstraXException(AstraXException.ErrorCode.E3000, "Error placing tile with id: " + id);
        }
        this.data.place(x, y, id);
    }

    public void registerTile(T object, Short id) {
        if (!this.objectIndex.containsKey(id)) {
            this.objectIndex.put(id, object);
        }
    }

    public T getByLocalCoordinates(int x, int y) {
        Short tileId = this.data.get(x, y);
        return this.objectIndex.get(tileId);
    }

    public T get(int x, int y) {
        Short tileId = this.data.get(x + this.getWidth() / 2, y + this.getHeight() / 2);
        return this.objectIndex.get(tileId);
    }

    public boolean isEmptyLocalCoordinates(int x, int y) {
        Short tileId = this.data.get(x, y);
        return this.objectIndex.get(tileId) == null;
    }

    public boolean isEmpty(int x, int y) {
        Short tileId = this.data.get(x + this.getWidth() / 2, y + this.getHeight() / 2);
        return this.objectIndex.get(tileId) == null;
    }

    public int getWidth() {
        return this.data.getWidth();
    }

    public int getHeight() {
        return this.data.getHeight();
    }

    public void clear() {
        this.data.clear();
        this.objectIndex.clear();
    }
}

