/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.collections;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MultiLinkedList<T> {
    private Node<T> root = new Node();

    public MultiLinkedList() {
    }

    public MultiLinkedList(T value) {
        this.root.setValue(value);
    }

    public void setRoot(Node<T> node) {
        this.root = node;
    }

    protected Node<T> getRoot() {
        return this.root;
    }

    public T getValue() {
        return this.root.getValue();
    }

    public void addChild(Node<T> node) {
        this.root.addChild(node);
    }

    public boolean containsChild(Node<T> node) {
        return this.root.containsChild(node);
    }

    public boolean containsChildRecursive(Node<T> node) {
        return this._containsChildRecursive(this.root, node);
    }

    private boolean _containsChildRecursive(Node parent, Node<T> node) {
        boolean foundChild = parent.containsChild(node);
        if (!foundChild) {
            for (int i2 = 0; i2 < parent.getChildrenCount(); ++i2) {
                foundChild = foundChild || this._containsChildRecursive(parent.getChildAt(i2), node);
            }
        }
        return foundChild;
    }

    public void removeChild(Node<T> node) {
        this.root.removeChild(node);
    }

    public List<Node> getChildren() {
        ArrayList<Node> children = new ArrayList<Node>();
        for (Node node : ((Node)this.root).children) {
            children.add(node);
        }
        return children;
    }

    public List<Node<T>> getChildrenOfDepth(int depth) {
        if (depth < 0) {
            throw new IllegalArgumentException("Depth can't be negative!");
        }
        ArrayList<Node<T>> result = new ArrayList<Node<T>>();
        this._getChildrenOfDepthRecursive(result, 0, depth, this.root);
        return result;
    }

    private void _getChildrenOfDepthRecursive(List<Node<T>> result, int currentDepth, int depth, Node parent) {
        if (currentDepth == depth) {
            result.add(parent);
        } else {
            for (int i2 = 0; i2 < parent.getChildrenCount(); ++i2) {
                this._getChildrenOfDepthRecursive(result, currentDepth + 1, depth, parent.getChildAt(i2));
            }
        }
    }

    public static <T> Node<T> getNode(T value) {
        Node<T> node = new Node<T>();
        node.setValue(value);
        return node;
    }

    public static <T> Node<T> getNode(T value, T ... children) {
        Node node = new Node();
        node.setValue(value);
        for (T child : children) {
            Node<T> childNode = new Node<T>();
            childNode.setValue(child);
            node.addChild(childNode);
        }
        return node;
    }

    public String toString() {
        return "MultiLinkedList{root=" + this.root + '}';
    }

    public static class Node<T> {
        private T value;
        private List<Node> parents = new ArrayList<Node>();
        private List<Node> children = new ArrayList<Node>();

        public Node() {
        }

        public Node(T value) {
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public void addParent(Node<T> node) {
            if (Objects.equals(this, node)) {
                return;
            }
            this.parents.add(node);
            if (!node.containsChild(this)) {
                node.addChild(this);
            }
        }

        public void removeParent(Node<T> node) {
            if (Objects.equals(this, node)) {
                return;
            }
            this.parents.remove(node);
            if (node.containsChild(this)) {
                node.removeChild(this);
            }
        }

        public void removeParentAt(int index) {
            Node removed = this.children.remove(index);
            if (this.containsParent(removed)) {
                removed.removeParent(this);
            }
        }

        public Node<T> getParentAt(int index) {
            return this.parents.get(index);
        }

        public int getParentCount() {
            return this.parents.size();
        }

        public boolean containsParent(Node<T> parent) {
            return this.parents.contains(parent);
        }

        public boolean containsParent(MultiLinkedList<T> parent) {
            return this.parents.contains(((MultiLinkedList)parent).root);
        }

        public void addChild(Node<T> node) {
            if (Objects.equals(this, node)) {
                return;
            }
            this.children.add(node);
            if (!node.containsParent(this)) {
                node.addParent(this);
            }
        }

        public void removeChild(Node<T> node) {
            if (Objects.equals(this, node)) {
                return;
            }
            this.children.remove(node);
            if (node.containsParent(this)) {
                node.parents.remove(this);
            }
        }

        public void removeChildAt(int index) {
            Node removed = this.children.remove(index);
            if (removed.containsParent(this)) {
                removed.parents.remove(this);
            }
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public Node<T> getChildAt(int index) {
            return this.children.get(index);
        }

        public int getChildrenCount() {
            return this.children.size();
        }

        public boolean containsChild(Node<T> child) {
            return this.children.contains(child);
        }

        public String toString() {
            return "Node{ value=" + this.value + ", children=" + this.children + "}\n";
        }
    }
}

