/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.sequences;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.neutronio.astrax.util.sequences.SequenceGenerator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class NumberGenerator
implements SequenceGenerator {
    private Random random;
    private long seed;

    public NumberGenerator(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }

    public void setSeed(long seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }

    public Random getRandom() {
        return this.random;
    }

    public long getSeed() {
        return this.seed;
    }

    public float getRandomFloat(float max, float min) {
        if (max < min) {
            throw new IllegalArgumentException("Min can't be larger than max!");
        }
        return this.random.nextFloat() * (max - min) + min;
    }

    public boolean isTrue(float probability) {
        float randomFloat;
        return (probability = MathUtils.clamp(probability, 0.0f, 100.0f)) >= (randomFloat = this.getRandomFloat(100.0f, 0.0f));
    }

    public int getRandomInteger(int max, int min) {
        if (max < min) {
            throw new IllegalArgumentException("Min can't be larger than max!");
        }
        return (int)(this.random.nextFloat() * (float)(max - min) + (float)min);
    }

    public <T> T getRandomEntry(Array<T> array) {
        if (array.size == 1) {
            return array.get(0);
        }
        int randomInteger = this.getRandomInteger(array.size, 0);
        return array.get(randomInteger);
    }

    public <T> T getRandomEntry(T[] array) {
        if (array.length == 1) {
            return array[0];
        }
        int randomInteger = this.getRandomInteger(array.length, 0);
        return array[randomInteger];
    }

    public <T> T getRandomEntry(List<T> array) {
        if (array.size() == 1) {
            return array.get(0);
        }
        int randomInteger = this.getRandomInteger(array.size(), 0);
        return array.get(randomInteger);
    }

    public <T> T getRandomEntry(Map<?, T> map) {
        int randomInteger = this.getRandomInteger(map.size(), 0);
        return map.get(map.keySet().toArray()[randomInteger]);
    }
}

