/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.tools;

import com.neutronio.astrax.app.repository.DataRepository;
import com.neutronio.astrax.util.DateFormats;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;

public class DataPackTranslationGenerator {
    Logger logger = Logger.getLogger(this.getClass().getSimpleName());

    public StringBuilder generate(DataRepository ... repositories) {
        StringBuilder fileContent = new StringBuilder();
        fileContent.append("# This is a generated localization file\n");
        fileContent.append("# Generated by class " + this.getClass().getCanonicalName() + "\n");
        fileContent.append("# Use this file as template for other languages.\n");
        fileContent.append("# Generated: ").append(DateFormats.FULL.format(new Date())).append("\n\n");
        for (DataRepository repository : repositories) {
            this.logger.fine("Generating translation for repository: " + repository.getClass().getCanonicalName());
            fileContent.append("### ").append(repository.getClass().getSimpleName()).append(" ### \n\n");
            List data = repository.all();
            for (Object object : data) {
                String idValue = null;
                try {
                    Field fieldID = object.getClass().getField("id");
                    idValue = (String)fieldID.get(object);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                try {
                    Field fieldName = object.getClass().getDeclaredField("name");
                    fileContent.append(idValue).append("_").append("name=").append(fieldName.get(object)).append("\n");
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                try {
                    Field fieldDescription = object.getClass().getDeclaredField("description");
                    fileContent.append(idValue).append("_").append("description=").append(fieldDescription.get(object)).append("\n");
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                fileContent.append("\n");
            }
            fileContent.append("\n");
        }
        return fileContent;
    }

    public void generate(List<DataRepository> repositories) {
        StringBuilder file = new StringBuilder();
        file.append("# This is a generated localization file, generated by class " + this.getClass().getCanonicalName() + "\n");
        file.append("# Use this file as template for other languages.\n");
        file.append("# Generated: ").append(DateFormats.FULL.format(new Date()));
        for (DataRepository repository : repositories) {
            List data = repository.all();
            for (Object object : data) {
                String idValue = null;
                try {
                    Field fieldID = object.getClass().getDeclaredField("id");
                    idValue = (String)fieldID.get(object);
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                try {
                    Field fieldName = object.getClass().getDeclaredField("name");
                    file.append(idValue).append("_").append("name=").append(fieldName.get(object)).append("\n");
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                try {
                    Field fieldDescription = object.getClass().getDeclaredField("description");
                    file.append(idValue).append("_").append("description=").append(fieldDescription.get(object)).append("\n");
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

