/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.tools;

import com.neutronio.astrax.io.JavaFileHandler;
import com.neutronio.astrax.util.DateFormats;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class TranslationGenerator {
    public List<String> convert(Properties properties) {
        ArrayList<String> propertyList = new ArrayList<String>();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            propertyList.add((String)keys.nextElement());
        }
        return propertyList;
    }

    public String generate(String packageName, String className, List<String> propertyKeys) {
        String packageCode = String.format("package %s;\n\n", packageName);
        String comment = "/**\n * A generated class providing access to translation identifiers.\n * Do not manually edit this! Instead, add translation strings to the \n * translation properties file and run the generator again. \n\n * Generated: " + DateFormats.FULL.format(new Date()) + "\n\n * @see com.neutronio.astrax.util.tools.TranslationGenerator\n */\n";
        String classCode = "public class %s {\n%s}";
        StringBuilder fields = new StringBuilder();
        for (String key : propertyKeys) {
            fields.append("   ").append("public static final String ").append(key.toUpperCase()).append(" = ").append("\"").append(key).append("\";\n");
        }
        return packageCode + comment + String.format(classCode, className, fields);
    }

    public void generateAndSaveCode(String sourcePropertyFile, String className, String packageName, String destPath) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(sourcePropertyFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        TranslationGenerator translationGenerator = new TranslationGenerator();
        List<String> convert2 = translationGenerator.convert(properties);
        Collections.sort(convert2);
        String generatedCode = translationGenerator.generate(packageName, className, convert2);
        JavaFileHandler javaFileHandler = new JavaFileHandler();
        String destination = destPath + "/" + packageName.replace('.', '/') + "/" + className + ".java";
        try {
            File file = new File(destination);
            if (!file.exists()) {
                file.createNewFile();
            }
            javaFileHandler.saveFileContents(generatedCode, file.getPath(), null, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        TranslationGenerator translationGenerator = new TranslationGenerator();
        translationGenerator.generateAndSaveCode("core/assets/lang/astrax.properties", "AstraXAppTranslations", "com.neutronio.astrax.lang", "core/src/main/java/");
    }
}

