/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.tools.trait;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextArea;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTrait;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.ui.IconSelectBox;
import com.neutronio.astrax.ui.commons.forms.AbstractForm;
import com.neutronio.astrax.ui.commons.forms.Form;
import com.neutronio.astrax.ui.commons.forms.ValidationResult;

public class TraitEditForm
extends AbstractForm {
    private PlanetTrait trait;
    private Label idLabel;
    private TextField idTextField;
    private Label nameLabel;
    private TextField nameTextField;
    private Label iconLabel;
    private IconSelectBox iconSelectBox;
    private Label pointsLabel;
    private TextField pointsTextField;
    private Label descriptionLabel;
    private TextArea descriptionTextArea;

    public TraitEditForm(ComponentFactory componentFactory) {
        super(componentFactory);
        Skin skin = componentFactory.getSkin();
        this.idLabel = new Label((CharSequence)"ID:*", this.panelStyle.labelStyle);
        this.idTextField = new TextField("", skin);
        this.nameLabel = new Label((CharSequence)"Name:*", this.panelStyle.labelStyle);
        this.nameTextField = new TextField("", skin);
        this.iconLabel = new Label((CharSequence)"Icon:*", this.panelStyle.labelStyle);
        this.iconSelectBox = new IconSelectBox(componentFactory);
        this.iconSelectBox.getIconPicker().setIcons("trait_ocean", "trait_mountains", "trait_magnetic", "trait_magma", "trait_microbes", "trait_quake", "trait_clouds", "surface_star_yellow");
        this.pointsLabel = new Label((CharSequence)"Points:*", this.panelStyle.labelStyle);
        this.pointsTextField = new TextField("1", skin);
        this.descriptionLabel = new Label((CharSequence)"Description:*", this.panelStyle.labelStyle);
        this.descriptionTextArea = new TextArea("", skin);
        this.descriptionTextArea.setPrefRows(3.0f);
    }

    public void storeValuesInto(PlanetTrait store) {
        store.id = this.idTextField.getText();
        store.name = this.nameTextField.getText();
        store.icon = this.iconSelectBox.getSelectedDrawableName();
        store.discoveryPoints = Integer.parseInt(this.pointsTextField.getText());
        store.description = this.descriptionTextArea.getText();
    }

    public void load(PlanetTrait trait) {
        this.trait = trait;
        this.idTextField.setText(trait.id);
        this.nameTextField.setText(trait.name);
        this.iconSelectBox.setSelectedDrawableName(trait.icon);
        this.pointsTextField.setText(trait.discoveryPoints + "");
        this.descriptionTextArea.setText(trait.description);
    }

    @Override
    public void construct() {
        this.clear();
        this.add(this.idLabel).left().minWidth(this.panelStyle.minLabelWidth).padRight(this.panelStyle.columnPadding).padBottom(this.panelStyle.rowPadding);
        this.add(this.idTextField).minWidth(this.panelStyle.minValueWidth).padBottom(this.panelStyle.rowPadding);
        this.row();
        this.add(this.nameLabel).left().minWidth(this.panelStyle.minLabelWidth).padRight(this.panelStyle.columnPadding).padBottom(this.panelStyle.rowPadding);
        this.add(this.nameTextField).minWidth(this.panelStyle.minValueWidth).padBottom(this.panelStyle.rowPadding);
        this.row();
        this.add(this.iconLabel).left().minWidth(this.panelStyle.minLabelWidth).padRight(this.panelStyle.columnPadding).padBottom(this.panelStyle.rowPadding);
        this.add(this.iconSelectBox).minWidth(this.panelStyle.minValueWidth).padBottom(this.panelStyle.rowPadding);
        this.row();
        this.add(this.pointsLabel).left().minWidth(this.panelStyle.minLabelWidth).padRight(this.panelStyle.columnPadding).padBottom(this.panelStyle.rowPadding);
        this.add(this.pointsTextField).minWidth(this.panelStyle.minValueWidth).padBottom(this.panelStyle.rowPadding);
        this.row();
        this.add(this.descriptionLabel).left().minWidth(this.panelStyle.minLabelWidth).padRight(this.panelStyle.columnPadding).padBottom(this.panelStyle.rowPadding);
        this.add(this.descriptionTextArea).minWidth(this.panelStyle.minValueWidth).padBottom(this.panelStyle.rowPadding);
        this.pack();
    }

    @Override
    public ValidationResult validateForm(ValidationResult validationResult) {
        if (validationResult == null) {
            validationResult = new ValidationResult();
        }
        if (this.idTextField.getText().trim().isEmpty()) {
            this.idTextField.addAction(Actions.color(Color.RED, 0.3f));
            validationResult.addMessage("Id can't be empty!");
            validationResult.status(Form.ValidationStatus.INVALID);
        }
        if (this.nameTextField.getText().trim().isEmpty()) {
            validationResult.addMessage("Name can't be empty!");
            validationResult.status(Form.ValidationStatus.INVALID);
        }
        if (this.iconSelectBox.getSelectedDrawableName().trim().isEmpty()) {
            validationResult.addMessage("Icon can't be empty!");
            validationResult.status(Form.ValidationStatus.INVALID);
        } else {
            String drawableID = this.iconSelectBox.getSelectedDrawableName();
            boolean has = this.componentFactory.getSkin().has(drawableID, Drawable.class);
            try {
                this.componentFactory.getSkin().getDrawable(drawableID);
            }
            catch (Exception e) {
                validationResult.addMessage("Icon not found. " + e.getMessage() + " has " + has);
            }
        }
        String text = this.pointsTextField.getText();
        try {
            Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            validationResult.addMessage("Only numbers allowed as discovery Points!");
            validationResult.status(Form.ValidationStatus.INVALID);
        }
        if (this.descriptionTextArea.getText().trim().isEmpty()) {
            validationResult.addMessage("Description can't be empty!");
            validationResult.status(Form.ValidationStatus.INVALID);
        }
        if (validationResult.getStatus() == Form.ValidationStatus.VALID) {
            validationResult.addMessage("Submit successful.");
        }
        return validationResult;
    }

    @Override
    public void resetForm() {
        this.load(this.trait);
    }

    @Override
    public void resetStyles() {
        this.descriptionLabel.setStyle(this.panelStyle.labelStyle);
        this.iconLabel.setStyle(this.panelStyle.labelStyle);
        this.nameLabel.setStyle(this.panelStyle.labelStyle);
        this.pointsLabel.setStyle(this.panelStyle.labelStyle);
        this.idLabel.setStyle(this.panelStyle.labelStyle);
    }

    @Override
    public void resetValues() {
        this.resetForm();
    }
}

