/*
 * Decompiled with CFR 0.152.
 */
package com.neutronio.astrax.util.tools.trait;

import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.ui.Tree;
import com.badlogic.gdx.scenes.scene2d.utils.ClickListener;
import com.neutronio.astrax.app.datapack.game.mechanics.discovery.Trait;
import com.neutronio.astrax.app.datapack.game.world.galaxy.planet.PlanetTraitRepository;
import com.neutronio.astrax.app.repository.GenericRepository;
import com.neutronio.astrax.ui.ComponentFactory;
import com.neutronio.astrax.util.Tech;
import com.neutronio.astrax.util.TechTree;
import com.neutronio.astrax.util.collections.MultiLinkedList;
import java.util.List;
import java.util.logging.Logger;

public class TraitTreeComponent
extends Table {
    private Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private Tree tree;

    public TraitTreeComponent(ComponentFactory factory) {
        super(factory.getSkin());
        this.tree = new Tree(factory.getSkin());
        this.tree.setPadding(5.0f);
        this.tree.setIconSpacing(4.0f, 6.0f);
        this.tree.setYSpacing(5.0f);
        this.tree.addListener(new ClickListener(){

            @Override
            public void clicked(InputEvent event, float x, float y) {
                super.clicked(event, x, y);
                TraitTreeComponent.this.logger.fine("Clicked : " + event.getTarget());
            }
        });
        this.add(this.tree);
    }

    public <T extends GenericRepository> TechTree<Trait> convertToTraitTree(T traitRepository, TechTree<String> traitTree) {
        TechTree<Trait> result = new TechTree<Trait>();
        Tech<Trait> tech = new Tech().withChildren(((Tech)traitTree.getValue()).getMaxChildren()).withProbability(((Tech)traitTree.getValue()).getProbability()).withUserObject((Trait)traitRepository.find((String)((Tech)traitTree.getValue()).getUserObject()));
        MultiLinkedList.Node<Tech<Trait>> rootNode = new MultiLinkedList.Node<Tech<Trait>>(tech);
        result.setRoot(rootNode);
        this.convertToTraitTreeRecursively(traitRepository, rootNode, traitTree.getChildren());
        return result;
    }

    private <T extends GenericRepository> void convertToTraitTreeRecursively(T traitRepository, MultiLinkedList.Node<Tech<Trait>> currentNode, List<MultiLinkedList.Node> currentChildren) {
        for (MultiLinkedList.Node techNode : currentChildren) {
            Tech<Trait> childTech = new Tech().withChildren(((Tech)techNode.getValue()).getMaxChildren()).withProbability(((Tech)techNode.getValue()).getProbability()).withUserObject((Trait)traitRepository.find((String)((Tech)techNode.getValue()).getUserObject()));
            MultiLinkedList.Node<Tech<Trait>> childNode = new MultiLinkedList.Node<Tech<Trait>>(childTech);
            currentNode.addChild(childNode);
            this.convertToTraitTreeRecursively(traitRepository, childNode, techNode.getChildren());
        }
    }

    public TechTree<String> convertToIDTree(TechTree<Trait> traitTree) {
        this.convertToTraitTree(new PlanetTraitRepository(), null);
        return null;
    }

    public <T extends Trait> void update(TechTree<T> traitTree) {
        this.tree.clearChildren();
        this.tree.getSelection().setMultiple(false);
        this.tree.getSelection().setToggle(false);
        Tech currentTech = (Tech)traitTree.getValue();
        List<MultiLinkedList.Node> currentChildren = traitTree.getChildren();
        Node rootNode = new Node(((Trait)currentTech.getUserObject()).getName());
        this.addNodeRecursively(rootNode, currentTech, currentChildren);
        this.tree.add(rootNode);
        this.tree.pack();
        this.pack();
    }

    private <T extends Trait> void addNodeRecursively(Node currentNode, Tech<T> currentTech, List<MultiLinkedList.Node> currentChildren) {
        for (MultiLinkedList.Node techNode : currentChildren) {
            Node childNode = new Node(((Trait)((Tech)techNode.getValue()).getUserObject()).getName());
            currentNode.add(childNode);
            this.addNodeRecursively(childNode, (Tech)techNode.getValue(), techNode.getChildren());
        }
    }

    private class Node
    extends Tree.Node<Node, String, TextButton> {
        public Node(String text) {
            super(new TextButton(text, TraitTreeComponent.this.getSkin(), "primary-compact"));
            this.setValue(text);
        }
    }
}

