/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.config;

import java.util.Optional;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.engine.config.ClassNamePatternParameterConverter;
import org.junit.jupiter.engine.config.EnumConfigurationParameterConverter;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;

@API(status=API.Status.INTERNAL, since="5.4")
public class DefaultJupiterConfiguration
implements JupiterConfiguration {
    private static final EnumConfigurationParameterConverter<ExecutionMode> executionModeConverter = new EnumConfigurationParameterConverter<ExecutionMode>(ExecutionMode.class, "parallel execution mode");
    private static final EnumConfigurationParameterConverter<TestInstance.Lifecycle> lifecycleConverter = new EnumConfigurationParameterConverter<TestInstance.Lifecycle>(TestInstance.Lifecycle.class, "test instance lifecycle mode");
    private final ConfigurationParameters configurationParameters;

    public DefaultJupiterConfiguration(ConfigurationParameters configurationParameters) {
        this.configurationParameters = Preconditions.notNull(configurationParameters, "ConfigurationParameters must not be null");
    }

    @Override
    public Optional<String> getRawConfigurationParameter(String key) {
        return this.configurationParameters.get(key);
    }

    @Override
    public boolean isParallelExecutionEnabled() {
        return this.configurationParameters.getBoolean("junit.jupiter.execution.parallel.enabled").orElse(false);
    }

    @Override
    public boolean isExtensionAutoDetectionEnabled() {
        return this.configurationParameters.getBoolean("junit.jupiter.extensions.autodetection.enabled").orElse(false);
    }

    @Override
    public ExecutionMode getDefaultExecutionMode() {
        return executionModeConverter.get(this.configurationParameters, "junit.jupiter.execution.parallel.mode.default", ExecutionMode.SAME_THREAD);
    }

    @Override
    public TestInstance.Lifecycle getDefaultTestInstanceLifecycle() {
        return lifecycleConverter.get(this.configurationParameters, "junit.jupiter.testinstance.lifecycle.default", TestInstance.Lifecycle.PER_METHOD);
    }

    @Override
    public Predicate<ExecutionCondition> getExecutionConditionFilter() {
        return new ClassNamePatternParameterConverter().get(this.configurationParameters, "junit.jupiter.conditions.deactivate");
    }
}

