/*
 * Decompiled with CFR 0.152.
 */
package space.earlygrey.shapedrawer;

import com.badlogic.gdx.utils.Array;
import space.earlygrey.shapedrawer.BatchManager;
import space.earlygrey.shapedrawer.PolygonBatchManager;

public class Drawing {
    BatchManager batchManager;
    Array<float[]> vertexBatches;

    Drawing(BatchManager batchManager) {
        this.batchManager = batchManager;
        this.vertexBatches = new Array();
    }

    public void draw() {
        if (this.batchManager.r == null) {
            throw new IllegalStateException("The texture region is null. Please set a texture region first (e.g. in the constructor or by calling setTextureRegion(TextureRegion region))");
        }
        for (int i2 = 0; i2 < this.vertexBatches.size; ++i2) {
            float[] vertices = this.vertexBatches.get(i2);
            this.getBatchManager().getBatch().draw(this.batchManager.r.getTexture(), vertices, 0, vertices.length);
        }
    }

    void pushVertices() {
        float[] vertices = new float[this.getBatchManager().getVerticesArrayIndex()];
        System.arraycopy(this.getBatchManager().verts, 0, vertices, 0, vertices.length);
        this.vertexBatches.add(vertices);
    }

    void finalise() {
        this.vertexBatches.setSize(this.vertexBatches.size);
    }

    BatchManager getBatchManager() {
        return this.batchManager;
    }

    static class PolygonDrawing
    extends Drawing {
        Array<short[]> triangleBatches = new Array();

        PolygonDrawing(PolygonBatchManager batchManager) {
            super(batchManager);
        }

        @Override
        public void draw() {
            if (this.batchManager.r == null) {
                throw new IllegalStateException("The texture region is null. Please set a texture region first (e.g. in the constructor or by calling setTextureRegion(TextureRegion region))");
            }
            for (int i2 = 0; i2 < this.vertexBatches.size; ++i2) {
                float[] vertices = (float[])this.vertexBatches.get(i2);
                short[] triangles = this.triangleBatches.get(i2);
                this.getBatchManager().getBatch().draw(this.batchManager.r.getTexture(), vertices, 0, vertices.length, triangles, 0, triangles.length);
            }
        }

        @Override
        PolygonBatchManager getBatchManager() {
            return (PolygonBatchManager)super.getBatchManager();
        }

        @Override
        void pushVertices() {
            super.pushVertices();
            short[] triangles = new short[this.getBatchManager().getTrianglesArrayOffset()];
            System.arraycopy(this.getBatchManager().triangles, 0, triangles, 0, triangles.length);
            this.triangleBatches.add(triangles);
        }

        @Override
        void finalise() {
            super.finalise();
            this.triangleBatches.setSize(this.triangleBatches.size);
        }
    }
}

